var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$table = $('#tablaDatos');
	
	consultar();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultar(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catNavieras.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				columns: [
					{ "data": "nombrecorto" },
					{ "data": "razonsocial" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
	});
}


function guardar(){
	
	var vRazonSocial = $("#txtRazonSocial").val();
	var vNombreCorto = $("#txtNombreCorto").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vContacto = $("#txtContacto").val();
	var vCorreo = $("#txtCorreo").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar"            
            ,vRazonSocial:vRazonSocial
            ,vNombreCorto:vNombreCorto
            ,vRfc:vRfc
            ,vDomicilio:vDomicilio
            ,vContacto: vContacto			
			,vCorreo: vCorreo
			,vNoExterior: vNoExterior
			,vNoInterior: vNoInterior
			,vCp: vCp
			,vTelefono: vTelefono
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catNavieras.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	
	var vNid = $("#hfIdSeleccionado").val();
	var vRazonSocial = $("#txtRazonSocial").val();
	var vNombreCorto = $("#txtNombreCorto").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vContacto = $("#txtContacto").val();
	var vCorreo = $("#txtCorreo").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();

    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,vNid:vNid
            ,vRazonSocial:vRazonSocial
            ,vNombreCorto:vNombreCorto
            ,vRfc:vRfc
            ,vDomicilio:vDomicilio
            ,vContacto: vContacto			
			,vCorreo: vCorreo
			,vNoExterior: vNoExterior
			,vNoInterior: vNoInterior
			,vCp: vCp
			,vTelefono: vTelefono
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catNavieras.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultar();
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "La naviera será dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/catNavieras.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
						consultar();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catNavieras.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			$("#txtRazonSocial").val(resp.datos[0].razonsocial);
			$("#txtNombreCorto").val(resp.datos[0].nombrecorto);
			$("#txtRfc").val(resp.datos[0].rfc);
			$("#txtDomicilio").val(resp.datos[0].domicilio);
			$("#txtContacto").val(resp.datos[0].responsable);
			$("#txtCorreo").val(resp.datos[0].correo);
			$("#txtNoExterior").val(resp.datos[0].exterior);	
			$("#txtNoInterior").val(resp.datos[0].interior);
			$("#txtCp").val(resp.datos[0].cp);
			$("#txtTelefono").val(resp.datos[0].telefono);	
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vRazonSocial = $("#txtRazonSocial").val();
	var vNombreCorto = $("#txtNombreCorto").val();
	var vRfc = $("#txtRfc").val();
	var vDomicilio =$("#txtDomicilio").val();
	var vContacto = $("#txtContacto").val();
	var vCorreo = $("#txtCorreo").val();
	var vNoExterior = $("#txtNoExterior").val();	
	var vNoInterior = $("#txtNoInterior").val();
	var vCp = $("#txtCp").val();
	var vTelefono = $("#txtTelefono").val();
	
	if(vRazonSocial.length === 0){
         $("#txtRazonSocial").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNombreCorto.length === 0){
         $("#txtNombreCorto").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vCorreo.length === 0){
         $("#txtCorreo").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vContacto.length === 0){
         $("#txtContacto").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vDomicilio.length === 0){
         $("#txtDomicilio").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vRfc.length === 0){
         $("#txtRfc").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(vTelefono.length === 0){
         $("#txtTelefono").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vCp.length === 0){
         $("#txtCp").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNoExterior.length === 0){
         $("#txtNoExterior").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vNoInterior.length === 0){
         $("#txtNoInterior").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtRazonSocial").val("");
	$("#txtNombreCorto").val("");
	$("#txtRfc").val("");
	$("#txtDomicilio").val("");
	$("#txtContacto").val("");
	$("#txtCorreo").val("");
	$("#txtNoExterior").val("");	
	$("#txtNoInterior").val("");
	$("#txtCp").val("");
	$("#txtTelefono").val("");
}