var $table;
var $tableTarifas;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$table = $('#tablaDatos');
	$tableTarifas  = $('#tablaTarifas');
	
	
	consultarClientes();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	$("#btnRegresar").click(function(){ verClientes(); });
	
	
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	limpiarCampos();
	$("#popupDetalle").modal("show");		
}

function consultarClientes(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {			
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				columns: [
					{ "data": "nombrecorto" },
					{ "data": "razonsocial" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vNombreCorto = "'" + oData.nombrecorto + "'";
							$(nTd).html('<span><a href="#" onclick="verTarifas(' + sData +','+ vNombreCorto +')"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		}
	});
}

function consultarTarifasCliente(pNidCliente, pNombreCliente){
      
	$("#hfNidCliente").val(pNidCliente);  
	$("#spanCliente").text(pNombreCliente);
	  
	var json_request = {
		tipoOperacion: "consultaXestado"  
		,pNidCliente:pNidCliente
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catTarifas.php",
		dataType: "json",
		async: true,
		success: function (resp) {		

			$tableTarifas.DataTable().clear().draw();
			$tableTarifas.dataTable().fnDestroy();
			$tableTarifas.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
				buttons: [{ extend: 'copy', text: 'Copiar' },
				{ extend: 'csv', text: 'Excel' },
				{ extend: 'print', text: 'Imprimir' }
				],
				language: JSON.parse(lenguaje),
				autoWidth: false,
				paging:false,
				columns: [
					{ "data": "trbInicial" },
					{ "data": "trbFinal" },
					{ "data": "costo" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='cargarTarifa(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		}
	});
}

function cargarTarifa(pNid){
	
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
		
	var pNidCliente = $("#hfNidCliente").val();
      
	var json_request = {
		tipoOperacion: "consultaXestado"  
		,pNidCliente:pNidCliente
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catTarifas.php",
		dataType: "json",
		async: true,
		success: function (resp) {		
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];	
				
				if(parseInt(json.nid) ===  parseInt(pNid)){					
					$("#txtInicio").val(json.trbInicial);
					$("#txtFin").val(json.trbFinal);
					$("#txtCosto").val(json.costo);	
					
					$("#popupDetalle").modal("show");
				}
			}
		}
	});
}

function verTarifas(pNidCliente, pNombreCliente){
	consultarTarifasCliente(pNidCliente,pNombreCliente);
	$("#divClientes").hide();
	$("#divTarifas").show();
}

function verClientes(){
	$("#divClientes").show();
	$("#divTarifas").hide();
}

function guardar(){
	
	var vNidCliente = $("#hfNidCliente").val();
	var vTrbInicial = $("#txtInicio").val();
	var vTrbFinal = $("#txtFin").val();
	var vCosto = $("#txtCosto").val();
		
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardar" 
			,vNidCliente:vNidCliente
            ,vTrbInicial:vTrbInicial
            ,vTrbFinal:vTrbFinal
            ,vCosto:vCosto
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catTarifas.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {	
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultarTarifasCliente(vNidCliente,$("#spanCliente").text());
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function actualizar(){
	var vNid = $("#hfIdSeleccionado").val();
	var vNidCliente = $("#hfNidCliente").val();
	var vTrbInicial = $("#txtInicio").val();
	var vTrbFinal = $("#txtFin").val();
	var vCosto = $("#txtCosto").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizar"
			,vNid:vNid
			,vNidCliente:vNidCliente
            ,vTrbInicial:vTrbInicial
            ,vTrbFinal:vTrbFinal
            ,vCosto:vCosto
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../moversa/dataAccess/catTarifas.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
               ajaxindicatorstop();
				consultarTarifasCliente(vNidCliente,$("#spanCliente").text());
				$("#popupDetalle").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var vNid = $("#hfIdSeleccionado").val();
	var vNidCliente = $("#hfNidCliente").val();
	
	var mensaje = "La tarifa será dada de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminar"
					,vNid:vNid
					,vNidCliente:vNidCliente
				};
				
				console.log(json_request);
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/catTarifas.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
		               ajaxindicatorstop();
		               consultarTarifasCliente(vNidCliente,$("#spanCliente").text());
						consultarClientes();
						$("#popupDetalle").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();
	
	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catTarifas.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			$("#txtInicio").val("");
			$("#txtFin").val("");
			$("#txtCosto").val("");	
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupDetalle").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vTrbInicial = $("#txtInicio").val();
	var vTrbFinal = $("#txtFin").val();
	var vCosto = $("#txtCosto").val();
	
	if(vTrbInicial.length === 0){
         $("#txtInicio").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vTrbFinal.length === 0){
         $("#txtFin").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vCosto.length === 0){
         $("#txtCosto").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function limpiarCampos(){
	$("#txtInicio").val("");
	$("#txtFin").val("");
	$("#txtCosto").val("");
}