
var $tableBuques;
var $tablePersonal;

var $datosJson;

var $tablePersonalProa; //Catalogo personal proa
var $tablePersonalPopa; //Catalogo personal popa

var $tableProa; //Tabla de personal agregado
var $tablePopa; //Tabla de personal agregado

var $tableRemolcadores;
var $tablePilotos;

var $tableServiciosTerminados;
var $tableServiciosProforma;
var $tableServiciosFacturado;
var $tableServiciosPendiente;

var $tableServicioRemolcadores;
var $tableServicioPilotos;

var cameras = new Array(); //create empty array to later insert available devices

$("document").ready(function () {
	$("#linkHistorico").addClass("subdrop");
	
   	//Iniciamos TABS
	$( "#tabs" ).tabs();
	$( "#tabsPrincipal" ).tabs();
	
   	inicialiaValores();
	$.getScript("../Moversa/assets/js/icheckTable.js");


});


function inicialiaValores(){
	
	consultaXestado();
		
	//Asignamos Tablas a variables
	$table = $("#tablaBuquesProgramados");
	$tablePersonal = $("#tablaPersonal");
	$tablePersonalProa = $("#tablaPersonalProa");
	$tablePersonalPopa = $("#tablaPersonalPopa");
	$tableRemolcadores = $("#tablaRemolcadores");
	$tablePilotos = $("#tablaPilotos");
	
		
	$tableServiciosTerminados = $("#tablaServiciosTerminados");
	$tableServiciosProforma = $("#tablaServiciosProforma");
	$tableServiciosFacturado = $("#tablaServiciosFacturados");
	$tableServiciosPendiente = $("#tablaServiciosPendientes");
	
	
	$tableProa = $('#tablaProa');
	$tablePopa = $('#tablaPopa');
	
	$tableServicioRemolcadores = $('#tablaServicioRemolcadores');
	$tableServicioPilotos = $('#tablaServicioPilotos');
		
	//Iniciamos Fechas
	$('input[id$=txtEta]').datetimepicker({
        format: 'd/m/Y H:m',
        lang: 'es',
        mask: true,
        timepicker: true
    });
	
	var vBitas = 1;
	var vDefensas = 2;
	var vPintura = 3;
	var vSugercion = 4;
	var vParamento = 5;
	
	var vOk=1;
	var vDano=0;
		
	$("#btnGuardar").click(function(){ imprimirProforma(); });	
	$("#btnRegresar").click(function(){ verGeneralServicio(); });	
	$("#btnProforma").click(function(){ enviarProforma(); });
	
	$("#btnFacturado").click(function(){ servicioEstadoCambiar(4); });
	$("#btnPendienteCobro").click(function(){ servicioEstadoCambiar(5); });
	$("#btnCobrados").click(function(){ servicioEstadoCambiar(6); });	
	
}

function apagarCamara(){
	Webcam.reset();
}



function consultarPersonal(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);
			
			    for (var i = 0; i < resp.datos.length; i++) {

                    var json = resp.datos[i];

                    $tablePersonal.append('<tr>' +
                        '    <td class="a-center "><input type="checkbox" class="flat" name="table_records"></td>' +
                        '    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanCodigo">' + json.nombre + '</span></td>' +
                        '    <td>' + json.paterno + '</td>' +
                        '    <td>' + json.materno + '</td>' +
                        '    <td>' + json.puesto + '</td>' +
                        '</tr>');

                    $.getScript("../Moversa/assets/js/icheckTable.js");
                }
					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}



function consultaXestado(){
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"6"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			
			$tableServiciosTerminados.DataTable().clear().draw();
			$tableServiciosTerminados.dataTable().fnDestroy();
			$tableServiciosTerminados.DataTable({
				data: resp.datos,
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				info:false,
				paging:false,
				searching:true,
				columns: [
					{
						
						"data": "viaje",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vImo = oData.imo;
							$(nTd).html("<span><a href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
						}
					},
					{
						
						"data": "servicioAmarre",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span>AMA"+ sData +"</span>");
						}
					},
					{ "data": "nidFactura" },
					{ "data": "buque" },
					{ "data": "eta" },
					{ "data": "naviera" },
					{ "data": "tipoServicio" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vBuque = "'" + oData.buque + "'";
							$(nTd).html('<span><a href="#" onclick="verDetalleServicio(' + sData + ','+ vBuque +',6)"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function muestraMarineTrafic(pImo) {
	localStorage.setItem("pImoConsultar", pImo);
	location.href = "/moversa/account.php?page=mapa";
}

function verDetalleServicio(pNidServicio, pBuque, pEstado){
	$("#hfNidServicio").val(pNidServicio);
	$("#divGenerales").hide();
	$("#divDetalle").show();
	
	$("#spanBuqueProforma").text(pBuque);

	consultaPosicionServicio();

	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:pEstado
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				
				if(parseInt(json.nid) === parseInt(pNidServicio)){
					
					$("#spanFolio").text("AMA" +json.servicioAmarre);
					$("#spanBuque").text(json.buque);
					$("#spanViaje").text(json.viaje);
					$("#spanTRB").text(json.trb);
					$("#spanEslora").text(json.eslora);
					$("#spanNaviera").text(json.naviera);
					$("#spanETA").text(json.eta);
					$("#spanMuelle").text(json.muelle);
					$("#spanOperacion").text(json.tipoServicio);
					$("#spanCliente").text(json.cliente);
					
					/*$("#spanBuqueProf").text(json.buque);
					$("#spanViajeProf").text(json.viaje);
					$("#spanTRBProf").text(json.trb);
					$("#spanEsloraProf").text(json.eslora);
					$("#spanNavieraProf").text(json.naviera);
					$("#spanETAProf").text(json.eta);
					$("#spanMuelleProf").text(json.muelle);
					$("#spanOperacionProf").text(json.tipoServicio);
					$("#spanClienteProf").text(json.cliente);
					$("#spanTotalProf").text(json.costo);*/
					

					$("#spanPrimerCabo").text(json.primerCabo);
					$("#spanUltimoCabo").text(json.ultimoCabo);
					
					//$("#spanFolioProf").text(json.nid);
					//$("#spanPrimerCaboProf").text(json.primerCabo);
					//$("#spanUltimoCaboProf").text(json.ultimoCabo);
					
					
				}
			}				
		},
		complete: function () {
			ajaxindicatorstop();
			consultaPersonalServicio(1);
			consultaPersonalServicio(2);
			
			consultaPilotosServicio();
			consultaRemolcadoresServicio();
			cargarArchivos();
			consultaCliente();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function consultaCliente(){
		
	var json_request = {
		tipoOperacion: "consultaCliente"            
		,pNidCliente:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {  

			var json = resp.datos[0];
			
			$("#spanNombreClienteProf").text(json.razonsocial);
			$("#spanRFCProf").text(json.rfc);
			$("#spanDireccionProf").text(json.domicilio);
			$("#spanCpProf").text(json.rfc);		
			
		},
		complete: function () {
			ajaxindicatorstop();
			//consultaPersonalServicio(1);
			//consultaPersonalServicio(2);
			
			//consultaPilotosServicio();
			//consultaRemolcadoresServicio();
			cargarArchivos();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function verGeneralServicio(){
	$("#divGenerales").show();
	$("#divDetalle").hide();
}


function consultaPersonalServicio(pNidPosicion){
	
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaPersonalServicio"            
		,pNidServicio:pNidServicio
		,pNidPosicion:pNidPosicion
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {

			if(parseInt(pNidPosicion) === 1){	
				$('#tablaProa tbody').empty();			
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#tablaProa").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
				}	
			}else{
				$('#tablaPopa tbody').empty();
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#tablaPopa").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
				}
			}
			
		
		}
	});
}

function consultaPilotosServicio(){
	$('#tablaServicioPilotos tbody').empty();
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaPilotosServicio"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#tablaServicioPilotos").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
			}
		}
	});
}

function consultaRemolcadoresServicio(){
	$('#tablaServicioRemolcadores tbody').empty();
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaRemolcadoresServicio"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#tablaServicioRemolcadores").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
			}	
		}
	});
}

function consultaPosicionServicio(){
	
	var pNidServicio = $("#hfNidServicio").val();
		
	var json_request = {
		tipoOperacion: "posicionConsultar"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];	
				
				//Bitas
				if(parseInt(json.nid) === 1){
					if(parseInt(json.estado) === 1){
						$("#spanBitas").text("Ok");
					}else{
						$("#spanBitas").text("Daño");
					}
				}
				
				//Defensa
				if(parseInt(json.nid) === 2){
					if(parseInt(json.estado) === 1){
						$("#spanDefensas").text("Ok");
					}else{
						$("#spanDefensas").text("Daño");
					}
				}
				
				//Pintura
				if(parseInt(json.nid) === 3){
					if(parseInt(json.estado) === 1){
						$("#spanPintura").text("Ok");
					}else{
						$("#spanPintura").text("Daño");
					}
				}
				
				//Sugercion
				if(parseInt(json.nid) === 4){
					if(parseInt(json.estado) === 1){
						$("#spanSugercion").text("Ok");
					}else{
						$("#spanSugercion").text("Daño");
					}
				}
				
				//Paramento
				if(parseInt(json.nid) === 5){
					if(parseInt(json.estado) === 1){
						$("#spanParamento").text("Ok");
					}else{
						$("#spanParamento").text("Daño");
					}
				}
			
			}

		}
	});
}

function imprimirProforma(){
	var vProforma = $("#tabProforma").html();
	var pNidServicio = $("#hfNidServicio").val();
	var pBuque = $("#spanBuque").text();
	
		var json_request = {
		tipoOperacion: "imprimirProforma",
		pNidServicio:pNidServicio,
		pHtmlProforma: vProforma
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);				
		},complete: function () {
			ajaxindicatorstop();
			$("#iframepdf").attr("src","/moversa/dataAccess/proformas/" + pNidServicio+ ".pdf");
			$("#popupProforma").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
	
}


function enviarProforma(){
	var pNidServicio = $("#hfNidServicio").val();
	var pBuque = $("#spanBuque").text();
	
	var json_request = {
		tipoOperacion: "enviarProforma",
		pNidServicio:pNidServicio,
		pBuque:pBuque
	};
   
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/core/smtp/phpSendMail.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {						
			MessageBox(resp.transaccion, resp.mensaje);	
		},
		complete: function () {
			ajaxindicatorstop();
			servicioEstadoCambiar(3);
			consultaXestado();
			verGeneralServicio();
			//GHG
			$("#popupProforma").modal("hide");
		},error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
		}
	});
}

function cargarArchivos(){
	var pNidServicio = $("#hfNidServicio").val();
	$("#divFotografias").empty();
      
	var json_request = {
		tipoOperacion: "consultaArchivos"            
		,pServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//ajaxindicatorstart();
		},
		success: function (resp) { 

			console.log(resp);
			if(resp.datos != null){
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#divFotografias").append('<a data-fancybox="gallery" href="dataAccess/'+ json.nombre +'" class="col-sm-2">'+
												'	<img src="dataAccess/'+ json.nombre +'" class="img-fluid">'+
												'</a>');
				}	
			}	
						
		},
		complete: function () {
			//ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}
