
var $tableBuques;
var $tablePersonal;

var $datosJson;

var $tablePersonalProa; //Catalogo personal proa
var $tablePersonalPopa; //Catalogo personal popa

var $tableProa; //Tabla de personal agregado
var $tablePopa; //Tabla de personal agregado

var $tableRemolcadores;
var $tablePilotos;

var $tableServiciosProgramados;

var $tableServicioRemolcadores;
var $tableServicioPilotos;

var vTransaccionFacturacion;
var vMensajeFacturacion;
var vPuedeModificar=true;

var cameras = new Array(); //create empty array to later insert available devices

$("document").ready(function () {
			
	$("#linkProgramados").addClass("subdrop");
   	//Iniciamos TABS
	$( "#tabs" ).tabs();
   	inicialiaValores();
	$.getScript("../moversa/assets/js/icheckTable.js");
	$("#btnCapturar").click(function(){ capturaFoto(); });
	$("#btnGuardarFoto").click(function(){ take_snapshot(); });
	
/*	navigator.mediaDevices.enumerateDevices() // get the available devices found in the machine
	.then(function(devices) {
		devices.forEach(function(device) {
			var i = 0;
			if(device.kind=== "videoinput"){ //filter video devices only
				cameras[i]= device.deviceId; // save the camera id's in the camera array
				i++;
				
				//console.log('Camara -->' + device.deviceId);
			}
		});
	})*/
		
});

function capturaFoto(){
		Webcam.set({
        width: 460,
        height: 350,
        image_format: 'jpeg',
        jpeg_quality: 99,
		sourceId: cameras[1]
    });
  
    Webcam.attach('#my_camera' );
	$("#popupFotografia").modal("show");
}

function inicialiaValores(){
	
	consultaXestado();
		
	//Asignamos Tablas a variables
	$table = $("#tablaBuquesProgramados");
	$tablePersonal = $("#tablaPersonal");
	$tablePersonalProa = $("#tablaPersonalProa");
	$tablePersonalPopa = $("#tablaPersonalPopa");
	$tableRemolcadores = $("#tablaRemolcadores");
	$tablePilotos = $("#tablaPilotos");
	$tableServiciosProgramados = $("#tablaServiciosProgramados");
	$tableProa = $('#tablaProa');
	$tablePopa = $('#tablaPopa');
	
	$tableServicioRemolcadores = $('#tablaServicioRemolcadores');
	$tableServicioPilotos = $('#tablaServicioPilotos');
		
	//Iniciamos Fechas
	$('input[id$=txtEta]').datetimepicker({
        format: 'd/m/Y H:m',
        lang: 'es',
        mask: true,
        timepicker: true
    });
	
	var vBitas = 1;
	var vDefensas = 2;
	var vPintura = 3;
	var vSugercion = 4;
	var vParamento = 5;
	
	var vOk=1;
	var vDano=0;
	
	
	//Asignamos eventos a los check
	$('#checkBitasA').on('ifChecked', function(event){			
		$('#checkBitasB').iCheck('uncheck');		
		grabaEstadoPosicion(vBitas,vOk);
	});
	
	$('#checkBitasB').on('ifChecked', function(event){		
		$('#checkBitasA').iCheck('uncheck');
		grabaEstadoPosicion(vBitas,vDano);
	});
	
	
	$('#checkDefensasA').on('ifChecked', function(event){		
		$('#checkDefensasB').iCheck('uncheck');
		grabaEstadoPosicion(vDefensas,vOk);
	});
	
	$('#checkDefensasB').on('ifChecked', function(event){		
		$('#checkDefensasA').iCheck('uncheck');
		grabaEstadoPosicion(vDefensas,vDano);
	});
	
	
	
	$('#checkPinturaA').on('ifChecked', function(event){		
		$('#checkPinturaB').iCheck('uncheck');
		grabaEstadoPosicion(vPintura,vOk);
	});
	
	$('#checkPinturaB').on('ifChecked', function(event){		
		$('#checkPinturaA').iCheck('uncheck');
		grabaEstadoPosicion(vPintura,vDano);
	});
	
	
	$('#checkSugercionA').on('ifChecked', function(event){		
		$('#checkSugercionB').iCheck('uncheck');
		grabaEstadoPosicion(vSugercion,vOk);
	});
	
	$('#checkSugercionB').on('ifChecked', function(event){		
		$('#checkSugercionA').iCheck('uncheck');
		grabaEstadoPosicion(vSugercion,vDano);
	});
	
	
	$('#checkParamentoA').on('ifChecked', function(event){		
		$('#checkParamentoB').iCheck('uncheck');
		grabaEstadoPosicion(vParamento,vOk);
	});
	
	$('#checkParamentoB').on('ifChecked', function(event){		
		$('#checkParamentoA').iCheck('uncheck');
		grabaEstadoPosicion(vParamento,vDano);
	});
	

	$("#btnProa").click(function(){ consultarPersonalProa(); });
	$("#btnPopa").click(function(){ consultarPersonalPopa(); });
	
	$("#btnConsultaRemolcadores").click(function(){ consultarRemolcadores(); });
	$("#btnAgregarRemolcadores").click(function(){ agregarRemolcadores(); });
	$("#btnConsultaPilotos").click(function(){ consultarPilotos(); });
	$("#btnAgregarPilotos").click(function(){ agregarPilotos(); });
	$("#btnRegresar").click(function(){ verGeneralServicio(); });	
	
	$("#btnPrimerCabo").click(function(){ capturaPrimerCabo(); });
	$("#btnUltimoCabo").click(function(){ capturaUltimoCabo(); });
	
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnAgregarPersonalProa").click(function(){ agregarPersonalProa(); });
	$("#btnAgregarPersonalPopa").click(function(){ agregarPersonalPopa(); });	
	$("#btnCapturarUltimoCabo").click(function(){ cerrarUltimoCabo(); });
	
}

function take_snapshot() {
		var pNidServicio = $("#hfNidServicio").val();
	
        Webcam.snap( function(data_uri) {
            $(".image-tag").val(data_uri);
            //document.getElementById('results').innerHTML = '<img src="'+data_uri+'"/>';
			var json_request = {
					tipoOperacion: "captura"            
					,pServicio:pNidServicio
					,pImg:data_uri
				};
				
				$.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/serviciosProgramados.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						$("#popupFotografia").modal("hide");					
					},
					complete: function () {
						ajaxindicatorstop();
						apagarCamara();
						cargarArchivos();
					},
					error: function (xhr, ajaxOptions, thrownError) {
						//MessageBox(0, "Error");
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
        } );
		
		
    }

function apagarCamara(){
	Webcam.reset();
}

function ventanaBuquesProgramados(){
	
		$.ajax({
		type: "GET",
		url: "https://www.mediport.com.mx/mediportMovil/Buques.svc/buquesProgramados",
        contentType: "application/json",
        dataType: "json",
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			var listaBuques = resp.d.datos;
			
			datosJson = listaBuques;
			
			    $table.dataTable().fnDestroy();
                $table.DataTable({
                    data: JSON.parse(listaBuques),
					language: JSON.parse(lenguaje),
                    autoWidth: false,
                    columns: [
						{ "data": "vid" },
                        { "data": "buque" },
                        { "data": "eta" },
						{ "data": "naviera" },
						{
                            "data": "vid",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                                $(nTd).html("<span><a href='#' onclick='seleccionarBuque(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
                            }
                        }
                    ]
                });
			
			$("#popupBuquesProgramados").modal("show");
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (e) {
			ajaxindicatorstop();
			console.log(e.message);
		}
	});

}

function seleccionarBuque(pIdViaje){
	
	var listaBuquesJson = JSON.parse(datosJson)
		
	for(var i=0; i < parseInt(listaBuquesJson.length);i++){
		var objBuque = listaBuquesJson[i];
		console.log(objBuque);
		if(parseInt(pIdViaje) === parseInt(objBuque.vid)){
			$("#txtBuque").val(objBuque.buque);
			$("#txtViaje").val(objBuque.vid);
			$("#txtTrb").val("0");
			$("#txtEslora").val(objBuque.eslora);
			$("#txtEta").val(objBuque.eta +" "+objBuque.h_eta);
			$("#txtNaviera").val(objBuque.naviera);			
		}
	}
	
	$("#popupBuquesProgramados").modal("hide");
}



function consultarPersonal(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);
			
			    for (var i = 0; i < resp.datos.length; i++) {

                    var json = resp.datos[i];

                    $tablePersonal.append('<tr>' +
                        '    <td class="a-center "><input type="checkbox" class="flat" name="table_records"></td>' +
                        '    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanCodigo">' + json.nombre + '</span></td>' +
                        '    <td>' + json.paterno + '</td>' +
                        '    <td>' + json.materno + '</td>' +
                        '    <td>' + json.puesto + '</td>' +
                        '</tr>');

                    $.getScript("../moversa/assets/js/icheckTable.js");
                }
					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

/*function consultarNavieras(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catNavieras.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			$("#ddlNaviera").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlNaviera").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');                    
			}				
		}
	});
}*/

function consultarMuelles(){
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catMuelles.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			
			$("#ddlMuelles").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlMuelles").append('<option value="'+ json.nid +'">'+ json.nombre +'</option>');                    
			}				
		}
	});
}

function guardar(){
	var pNidServicio = $("#hfNidServicio").val();
	var pBuque = $("#txtBuque").val();
	var pViaje = $("#txtViaje").val();
	var pTrb = $("#txtTrb").val();
	var pEslora = $("#txtEslora").val();
	var pNaviera = $("#ddlNaviera").val();
	var pEta = $("#txtEta").val();
	var pMuelle = $("#ddlMuelles").val();
	var pTipoOperacion = $("#ddlTipoOperacion").val();
	var pCliente = $("#ddlClientes").val();
	var pComentarios = $("#txtComentarios").val();
	var pViajeNaviera = $("#txtViajeNaviera").val();

	if(validaDatos()){
		if(validaPersonal()){
			var json_request = {
				tipoOperacion: "actualizarServicio" 
				,pNidServicio:pNidServicio
				,pBuque:pBuque
				,pViaje:pViaje
				,pTrb:pTrb
				,pEslora:pEslora
				,pNaviera: pNaviera				
				,pEta: pEta
				,pMuelle: pMuelle
				,pTipoOperacion: pTipoOperacion
				,pCliente: pCliente
				,pComentarios: pComentarios
				,pSupervisor:1
				,pViajeNaviera:pViajeNaviera
			};
			
			console.log(json_request);
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosProgramados.php",
				dataType: "json",
				async: true,
				beforeSend: function () {
					ajaxindicatorstart();
				},
				success: function (resp) {             
					//console.log(resp);								
					MessageBox(resp.transaccion, resp.mensaje);
				},
				complete: function () {
					ajaxindicatorstop();
					//consultar();
				},
				error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);
				}
			});
		}
	}
	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var pBuque = $("#txtBuque").val();
	var pViaje = $("#txtViaje").val();
	var pTrb = $("#txtTrb").val();
	var pEslora = $("#txtEslora").val();
	var pNaviera = $("#ddlNaviera").val();
	var pEta = $("#txtEta").val();
	var pMuelle = $("#ddlMuelles").val();
	var pTipoOperacion = $("#ddlTipoOperacion").val();
	var pComentarios = $("#txtComentarios").val();
	
	if(parseInt(pTipoOperacion) === -1 ){
        $("#ddlTipoOperacion").addClass('campo-requerido');
        respuesta=false;
    }	
	
	if(pEta.length === 0){
        $("#txtEta").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(parseInt(pMuelle) === -1){
        $("#ddlMuelles").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pBuque.length === 0){
        $("#txtBuque").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pViaje.length === 0){
        $("#txtViaje").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pTrb.length === 0){
        $("#txtTrb").addClass('campo-requerido');
        respuesta=false;
    }

	if(pEslora.length === 0){
        $("#txtEslora").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pNaviera.length === 0){
        $("#txtNaviera").addClass('campo-requerido');
        respuesta=false;
    }

	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}

function validaPersonal(){
	var respuesta=true;
    var mensaje="";
	
	var totalProa  = $tableProa.fnGetData().length;
	var totalPopa  = $tablePopa.fnGetData().length;
	
		
	if(parseInt(totalProa) === 0){
		respuesta = false;
	}	

	if(parseInt(totalPopa) === 0){
		respuesta = false;
	}		
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta agregar al personal que participar en la maniobra", "error");
    }
    
    return respuesta;
	
}

function cargarArchivos(){
	var pNidServicio = $("#hfNidServicio").val();
	$("#divFotografias").empty();
      
	var json_request = {
		tipoOperacion: "consultaArchivos"            
		,pServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			//ajaxindicatorstart();
		},
		success: function (resp) { 

			console.log(resp);
			if(resp.datos != null){
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#divFotografias").append('<a data-fancybox="gallery" href="dataAccess/'+ json.nombre +'" class="col-sm-2">'+
												'	<img src="dataAccess/'+ json.nombre +'" class="img-fluid">'+
												'</a>');
				}	
			}	
						
		},
		complete: function () {
			//ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultarPersonalProa(){
	$tablePersonalProa.dataTable().fnDestroy();
    $("#tablaPersonalProa tbody").empty();
	
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) { 
	
			//Recorremos el catalogo de personas
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];
				var estaAgregado=0;			
				

				//Si persona no se a agregado, se da como opcion en catalogo
				if(parseInt(estaAgregado) === 0){
					$tablePersonalProa.append('<tr>' +
					'    <td class="a-center"><input type="checkbox" class="flat" name="table_records"></td>' +
					'    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanNombre">' + json.nombre + " " + json.paterno + " " + json.materno + '</span></td>' +
					'    <td><span id="spanPuesto">' + json.puesto + '</span></td>' +
					'</tr>');
				}
			}
										
			$tablePersonalProa.DataTable({
				paging: false,
				searching: true,
				autoWidth: true,
				info:false,
				language: JSON.parse(lenguaje),
			});

			$.getScript("../moversa/assets/js/icheckTable.js");			
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupPersonalProa").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function consultarPersonalPopa(){
	$tablePersonalPopa.dataTable().fnDestroy();
    $("#tablaPersonalPopa tbody").empty();
	
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) { 
	
			//Recorremos el catalogo de personas
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];
				var estaAgregado=0;
			

				//Si persona no se a agregado, se da como opcion en catalogo
				if(parseInt(estaAgregado) === 0){
					$tablePersonalPopa.append('<tr>' +
					'    <td class="a-center"><input type="checkbox" class="flat" name="table_records"></td>' +
					'    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanNombre">' + json.nombre + " " + json.paterno + " " + json.materno + '</span></td>' +
					'    <td><span id="spanPuesto">' + json.puesto + '</span></td>' +
					'</tr>');
				}
			}
										
			$tablePersonalPopa.DataTable({
				paging: false,
				searching: true,
				autoWidth: true,
				info:false,
				language: JSON.parse(lenguaje),
			});

			$.getScript("../moversa/assets/js/icheckTable.js");			
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupPersonalPopa").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function consultarRemolcadores(){
    $("#tablaRemolcadores tbody").empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catRemolcadores.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);
			
			    for (var i = 0; i < resp.datos.length; i++) {

                    var json = resp.datos[i];

                    $tableRemolcadores.append('<tr>' +
                        '    <td class="a-center "><input type="checkbox" class="flat" name="table_records"></td>' +
                        '    <td> <input id="spanNid" type="hidden" value="' + json.nid + '" /> <span id="spanCodigo">' + json.compania + '</span></td>' +
                        '    <td><span id="spanNombre"> ' + json.nombre + '</span></td>' +
                        '</tr>');

                    $.getScript("../moversa/assets/js/icheckTable.js");
                }
					
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popupRemolcadores").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function agregarRemolcadores(){
	var pNidServicio = $("#hfNidServicio").val();
	console.log("=== Remolcadores === ");
	$("#tablaRemolcadores tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var pNidRemolcador = $(this).find("input[type=hidden]").val();
			var vNombre = $(this).find("#spanNombre").text();
            			
			var json_request = {
				tipoOperacion: "insertaRemolcador"            
				,pNidServicio:pNidServicio
				,pNidRemolcador:pNidRemolcador
			};
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosProgramados.php",
				dataType: "json",
				async: false,
				success: function (resp) {             
					console.log("Servicio ->" + pNidRemolcador);
					console.log(resp);
				}
			});	
			
        }
    });	
	$("#popupRemolcadores").modal("hide");
	consultaRemolcadoresServicio();
}

function consultarPilotos(){
	
	if(puedeModificar()){
		$("#tablaPilotos tbody").empty();
		var json_request = {
			tipoOperacion: "consultaXestado"            
			,pEstado:"1"
		};
		
		$.ajax({
			type: "POST",
			data: json_request,
			url: "../moversa/dataAccess/catPilotos.php",
			dataType: "json",
			async: true,
			beforeSend: function () {
				ajaxindicatorstart();
			},
			success: function (resp) {             
				console.log(resp);
				
					for (var i = 0; i < resp.datos.length; i++) {

						var json = resp.datos[i];

						$tablePilotos.append('<tr>' +
							'    <td class="a-center "><input type="checkbox" class="flat" name="table_records"></td>' +
							'    <td> <input id="spanNid" type="hidden" value="' + json.nid + '" /> <span id="spanNombre">' + json.nombre + '</span></td>' + 
							'    <td><span id="spanApellidos"> ' + json.apellidos + '</span></td>' +						
							'</tr>');

						$.getScript("../moversa/assets/js/icheckTable.js");
					}
						
			},
			complete: function () {
				ajaxindicatorstop();
				$("#popupPilotos").modal("show");
			},
			error: function (xhr, ajaxOptions, thrownError) {
				MessageBox(0, xhr.responseText);
			}
		});
	}
	
}

function agregarPilotos(){
	var pNidServicio = $("#hfNidServicio").val();
	console.log("=== Pilotos === ");
	$("#tablaPilotos tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var pNidPiloto = $(this).find("input[type=hidden]").val();
			var vNombre = $(this).find("#spanNombre").text();
			var vApellidos = $(this).find("#spanApellidos").text();
            
			var json_request = {
				tipoOperacion: "insertaPiloto"            
				,pNidServicio:pNidServicio
				,pNidPiloto:pNidPiloto
			};
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosProgramados.php",
				dataType: "json",
				async: false,
				success: function (resp) {             
					console.log("Servicio ->" + pNidPiloto);
					console.log(resp);
				}
			});	
			
        }
    });	
	$("#popupPilotos").modal("hide");
	consultaPilotosServicio();
}

function consultaXestado(){
    console.log("consultaXestado");
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"1"
	};
	
	console.log(json_request);
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);		
			$tableServiciosProgramados.DataTable().clear().draw();			
			$tableServiciosProgramados.dataTable().fnDestroy();
			$tableServiciosProgramados.DataTable({
				data: resp.datos,
				dom: 'Bfrtip',
                    buttons: [{ extend: 'copy', text: 'Copiar' },
                    { extend: 'csv', text: 'Excel' },
                    { extend: 'print', text: 'Imprimir' }
                    ],
				"language": JSON.parse(lenguaje),
				columns: [
					{
						
						"data": "viaje",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vImo = oData.imo;
							$(nTd).html("<span><a href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
						}
					},
					{ "data": "buque" },
					{ "data": "eta" },
					{ "data": "naviera" },
					{ "data": "tipoServicio" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='verDetalleServicio(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					},
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='#' onclick='eliminar(" + sData + ")'><i class='fa fa-trash fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
		    console.log("error ->" + xhr.responseText);	
			MessageBox(0, xhr.responseText);
		}
	});
}

function eliminar(pNid){
		
	var mensaje = "El servicio será dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "cambiarEstado"
					,pNidServicio:pNid
					,pNidEstado:"7"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/serviciosTerminados.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
						ajaxindicatorstop();
						consultaXestado();
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}

function muestraMarineTrafic(pImo) {
	localStorage.setItem("pImoConsultar", pImo);
	location.href = "/moversa/account.php?page=mapa";
}

function verDetalleServicio(pNidServicio){

	$("#hfNidServicio").val(pNidServicio);
	$("#divGenerales").hide();
	$("#divDetalle").show();
	
	//consultarNavieras();
	consultarMuelles();
	consultarClientes();
	consultaPosicionServicio();	
	consultarConceptos();
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             			
			console.log("DATOS DEL SERVICIO");
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				
				if(parseInt(json.nid) === parseInt(pNidServicio)){
					$("#txtBuque").val(json.buque);
					$("#txtViaje").val(json.viaje);
					$("#txtViajeNaviera").val(json.viajeNaviera);
					$("#txtTrb").val(json.trb);
					$("#txtEslora").val(json.eslora);
					$("#ddlNaviera").val(json.nidNaviera);
					$("#txtEta").val(json.eta);
					$("#ddlMuelles").val(json.nidMuelle);
					$("#ddlTipoOperacion").val(json.nidTipoServicio);
					$("#ddlClientes").val(json.nidCliente);
					$("#txtComentarios").val(json.observaciones);
					$("#spanPrimerCabo").text(json.primerCabo);
					$("#spanUltimoCabo").text(json.ultimoCabo);
				}
								
				if($("#spanPrimerCabo").text() != "00:00"){
					$("#btnPrimerCabo").attr('disabled',true);
				}else{
					$("#btnPrimerCabo").attr('disabled',false);
				}
			}				
		},
		complete: function () {
			ajaxindicatorstop();
			consultaPersonalServicio(1);
			consultaPersonalServicio(2);
			
			consultaPilotosServicio();
			consultaRemolcadoresServicio();
			cargarArchivos();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function verDetalleServicioTerminado(pNidServicio){

	$("#hfNidServicio").val(pNidServicio);
	$("#divGenerales").hide();
	$("#divDetalle").show();
	
	//consultarNavieras();
	consultarMuelles();
	consultarClientes();
	consultaPosicionServicio();	
	consultarConceptos();
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"2"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             			
			console.log("DATOS DEL SERVICIO");
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				
				if(parseInt(json.nid) === parseInt(pNidServicio)){
					$("#txtBuque").val(json.buque);
					$("#txtViaje").val(json.viaje);
					$("#txtViajeNaviera").val(json.viajeNaviera);
					$("#txtTrb").val(json.trb);
					$("#txtEslora").val(json.eslora);
					$("#ddlNaviera").val(json.nidNaviera);
					$("#txtEta").val(json.eta);
					$("#ddlMuelles").val(json.nidMuelle);
					$("#ddlTipoOperacion").val(json.nidTipoServicio);
					$("#ddlClientes").val(json.nidCliente);
					$("#txtComentarios").val(json.observaciones);
					$("#spanPrimerCabo").text(json.primerCabo);
					$("#spanUltimoCabo").text(json.ultimoCabo);
				}
								
				if($("#spanPrimerCabo").text() != "00:00"){
					$("#btnPrimerCabo").attr('disabled',true);
				}else{
					$("#btnPrimerCabo").attr('disabled',false);
				}
			}				
		},
		complete: function () {
			ajaxindicatorstop();
			consultaPersonalServicio(1);
			consultaPersonalServicio(2);
			
			consultaPilotosServicio();
			consultaRemolcadoresServicio();
			cargarArchivos();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function verGeneralServicio(){
	$("#divGenerales").show();
	$("#divDetalle").hide();
}


function consultarMuelles(){
    $("#ddlMuelles").empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catMuelles.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlMuelles").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlMuelles").append('<option value="'+ json.nid +'">'+ json.nombre +'</option>');                    
			}				
		}
	});
}

function consultarClientes(){
    $("#ddlClientes").empty();
	$("#ddlNaviera").empty();
		
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			
			$("#ddlClientes").append('<option value="-1">- Seleccione -</option>'); 
			$("#ddlNaviera").append('<option value="-1">- Seleccione -</option>');
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlClientes").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');                    
				$("#ddlNaviera").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');  
			}				
		}
	});
}

function consultaPersonalServicio(pNidPosicion){
	
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaPersonalServicio"            
		,pNidServicio:pNidServicio
		,pNidPosicion:pNidPosicion
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {

			if(parseInt(pNidPosicion) === 2){
				var tableProa = $("#tablaProa").DataTable();
				tableProa.clear().draw();
			
				$tableProa.dataTable().fnDestroy();
				$tableProa.DataTable({
					data: resp.datos,
					language: JSON.parse(lenguaje),
					autoWidth: false,
					searching:false,
					paging:false,
					info:false,
					columns: [
						{ "data": "nombre" },
						{ "data": "puesto" },
						{
							"data": "nid",
							"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
								$(nTd).html("<span><a id='btnEliminar' class='trash' href='#' onclick='personalBorrar(" + sData + ")'><i class='fa fa-trash fa-2x' style='padding-left: 10px;'></i></a></span>");
							}
						}
					]
				});	
			}else{
				var tablePopa = $("#tablaPopa").DataTable();
				tablePopa.clear().draw();
				
				$tablePopa.dataTable().fnDestroy();
				$tablePopa.DataTable({
					data: resp.datos,
					language: JSON.parse(lenguaje),
					autoWidth: false,
					searching:false,
					paging:false,
					info:false,
					columns: [
						{ "data": "nombre" },
						{ "data": "puesto" },
						{
							"data": "nid",
							"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
								$(nTd).html("<span><a id='btnEliminar' href='#' class='trash' onclick='personalBorrar(" + sData + ")'><i class='fa fa-trash fa-2x' style='padding-left: 10px;'></i></a></span>");
							}
						}
					]
				});	
			}
			
		
		}
	});
}

function consultaPilotosServicio(){
	
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaPilotosServicio"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {

			var tablaServiciosPilotos = $("#tablaServicioPilotos").DataTable();
			tablaServiciosPilotos.clear().draw();
			
			$tableServicioPilotos.dataTable().fnDestroy();
			$tableServicioPilotos.DataTable({
			data: resp.datos,
			language: JSON.parse(lenguaje),
			autoWidth: false,
			searching:false,
			paging:false,
			info:false,
			columns: [
					{ "data": "nombre" },
					{
						"data": "nidServPiloto",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a href='javascript:pilotosBorrar(" + sData + ")' class='trash'><i class='fa fa-trash fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});		
		}
	});
}

function consultaRemolcadoresServicio(){
	
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaRemolcadoresServicio"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {

			var tablaRemolcadores = $("#tablaServicioRemolcadores").DataTable();
			tablaRemolcadores.clear().draw();
			
			$tableServicioRemolcadores.dataTable().fnDestroy();
			$tableServicioRemolcadores.DataTable({
			data: resp.datos,
			language: JSON.parse(lenguaje),
			autoWidth: false,
			searching:false,
			paging:false,
			info:false,
			columns: [
					{ "data": "nombre" },
					{
						"data": "nidServRemolcador",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<span><a class='trash' href='javascript:remolcadorBorrar(" + sData + ")'><i class='fa fa-trash fa-2x' style='padding-left: 10px;'></i></a></span>");
						}
					}
				]
			});		
		}
	});
}

function consultaPosicionServicio(){
	
	var pNidServicio = $("#hfNidServicio").val();
	
	$('#checkBitasA').iCheck('uncheck');
	$('#checkDefensasA').iCheck('uncheck');
	$('#checkPinturaA').iCheck('uncheck');
	$('#checkSugercionA').iCheck('uncheck');
	$('#checkParamentoA').iCheck('uncheck');

	$('#checkBitasB').iCheck('uncheck');
	$('#checkDefensasB').iCheck('uncheck');
	$('#checkPinturaB').iCheck('uncheck');
	$('#checkSugercionB').iCheck('uncheck');
	$('#checkParamentoB').iCheck('uncheck');
	
	var json_request = {
		tipoOperacion: "posicionConsultar"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			
			if(resp.datos != null){
				if(parseInt(resp.datos.length) > 0){
						for (var i = 0; i < resp.datos.length; i++) {
						var json = resp.datos[i];	
						
						//Bitas
						if(parseInt(json.nid) === 1){
							if(parseInt(json.estado) === 1){
								$('#checkBitasA').iCheck('check');
							}else{
								$('#checkBitasB').iCheck('check');
							}
						}
						
						//Defensa
						if(parseInt(json.nid) === 2){
							if(parseInt(json.estado) === 1){
								$('#checkDefensasA').iCheck('check');
							}else{
								$('#checkDefensasB').iCheck('check');
							}
						}
						
						//Pintura
						if(parseInt(json.nid) === 3){
							if(parseInt(json.estado) === 1){
								$('#checkPinturaA').iCheck('check');
							}else{
								$('#checkPinturaB').iCheck('check');
							}
						}
						
						//Sugercion
						if(parseInt(json.nid) === 4){
							if(parseInt(json.estado) === 1){
								$('#checkSugercionA').iCheck('check');
							}else{
								$('#checkSugercionB').iCheck('check');
							}
						}
						
						//Paramento
						if(parseInt(json.nid) === 5){
							if(parseInt(json.estado) === 1){
								$('#checkParamentoA').iCheck('check');
							}else{
								$('#checkParamentoB').iCheck('check');
							}
						}
						
					}
				}	
			}
					
		}
	});
}


function capturaPrimerCabo(){	
	var pNidServicio = $("#hfNidServicio").val();

	if(puedeModificar()){
			//var fechaHora = cosultaFechaHoraServer();
			var pBuque = $("#txtBuque").val();
			
			var vTodoCorrecto = validaServicioCompleto();	
			
			if(vTodoCorrecto){
				var mensaje = "Se registrará el PRIMER CABO" ;	
				   swal({
					  title: "Esta seguro(a)?",
					  text:mensaje,
					  icon: "warning",
					  buttons: true,
					  dangerMode: true,
					})
					.then((willDelete) => {
					  if (willDelete) {						  
						primerCaboInsertar(pBuque);						  
					  } 					  
					});
			}
	}			
}

function primerCaboPDF(){
	
	var pHtml = formaEmail(1);
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "prierCaboPDF",
		pNidServicio:pNidServicio,
		pHtml: pHtml
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);				
		},complete: function () {
			//ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function capturaUltimoCabo(){	
	
	if(puedeModificar()){
		//var fechaHora = cosultaFechaHoraServer();
		
		var vTienePrimerCabo = $("#spanPrimerCabo").text();
					
		if(vTienePrimerCabo != '00:00'){
			var vTodoCorrecto = validaServicioCompleto();
		
			if(vTodoCorrecto){

				$("#divPregunta").show();
				$("#divResultado").hide();
				$("#btnCapturarUltimoCabo").show();
				$("#popupUltimoCabo").modal("show");
				
			}
		}else{
			MessageBox('0', "Debe registrar el primer cabo...!!!");	
		}
	}			
}


function agregarPersonalProa(){
	var contador=0;
	var pNidServicio = $("#hfNidServicio").val();
	
	$("#tablaPersonalProa tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var nid = $(this).find("input[type=hidden]").val();

            guardarPersonal(pNidServicio,nid,"2");			
			contador = contador + 1;
        }
    });
	
	if(parseInt(contador) > 0){
		MessageBox("1","Se agrego al persona con exito...!!!");
		consultaPersonalServicio(2);
		$("#popupPersonalProa").modal("hide");
	}else{
		MessageBox("0","Seleccione al personal a agregar...!!!");
	}
}

function agregarPersonalPopa(){
	var contador=0;
	var pNidServicio = $("#hfNidServicio").val();
	
	$("#tablaPersonalPopa tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var nid = $(this).find("input[type=hidden]").val();

            guardarPersonal(pNidServicio,nid,"1");			
			contador = contador + 1;
        }
    });
	
	if(parseInt(contador) > 0){
		MessageBox("1","Se agrego al persona con exito...!!!");
		consultaPersonalServicio(1);
		$("#popupPersonalPopa").modal("hide");
	}else{
		MessageBox("0","Seleccione al personal a agregar...!!!");
	}
}

function guardarPersonal(pNidServicio, pNidPersona, pNidPosicion){
	
	var json_request = {
		tipoOperacion: "personalInsertar"            
		,pNidServicio:pNidServicio
		,pNidPersona:pNidPersona
		,pNidPosicion:pNidPosicion
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(pNidPersona +" -> OK ");
		}
	});	
}

function grabaEstadoPosicion(pIdPosicion, pEstado){
	
	
	var pNidServicio = $("#hfNidServicio").val();
	
	/*console.log('pNidServicio -->' + pNidServicio);
	console.log('pIdPosicion -->' + pIdPosicion);
	console.log('pEstado -->' + pEstado);*/
	
	var json_request = {
		tipoOperacion: "posicionInsertar"            
		,pNidServicio:pNidServicio
		,pIdPosicion:pIdPosicion
		,pEstado:pEstado
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(pIdPosicion +" -> OK ");
			//MessageBox(resp.transaccion, resp.mensaje);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}

function personalBorrar(pNidPersonal){
	
	if(puedeModificar() && vPuedeModificar){
			var pNidServicio = $("#hfNidServicio").val();
	
			var json_request = {
				tipoOperacion: "personalBorrar"
				,pNidServicio:pNidServicio
				,pNidPersonal:pNidPersonal
			};
		   
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosProgramados.php",
				dataType: "json",
				async: true,
				beforeSend: function () {
					ajaxindicatorstart();
				},
				success: function (resp) {						
					console.log(resp);
					MessageBox(resp.transaccion, resp.mensaje);	
				},
				error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
				},
				complete: function () {
					ajaxindicatorstop();
					consultaPersonalServicio(1);
					consultaPersonalServicio(2);
				}
			});
	}


}

function pilotosBorrar(pNidPilotoServicio){
	
	if(puedeModificar() && vPuedeModificar){
		var pNidServicio = $("#hfNidServicio").val();
	
		var json_request = {
			tipoOperacion: "pilotoBorrar"
			,pNidServicio:pNidServicio
			,pNidPilotoServicio:pNidPilotoServicio
		};
	   
		$.ajax({
			type: "POST",
			data: json_request,
			url: "../moversa/dataAccess/serviciosProgramados.php",
			dataType: "json",
			async: true,
			beforeSend: function () {
				ajaxindicatorstart();
			},
			success: function (resp) {						
				console.log(resp);
				MessageBox(resp.transaccion, resp.mensaje);	
			},
			error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);
			},
			complete: function () {
				ajaxindicatorstop();
				consultaPilotosServicio();
			}
		});
	}	
}

function remolcadorBorrar(pNidRemolcadorServicio){
	
	if(puedeModificar() && vPuedeModificar){
		var pNidServicio = $("#hfNidServicio").val();
	
		var json_request = {
			tipoOperacion: "remolcadoresBorrar"
			,pNidServicio:pNidServicio
			,pNidRemolcadorServicio:pNidRemolcadorServicio
		};
	   
		$.ajax({
			type: "POST",
			data: json_request,
			url: "../moversa/dataAccess/serviciosProgramados.php",
			dataType: "json",
			async: true,
			beforeSend: function () {
				ajaxindicatorstart();
			},
			success: function (resp) {						
				console.log(resp);
				MessageBox(resp.transaccion, resp.mensaje);	
			},
			error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);
			},
			complete: function () {
				ajaxindicatorstop();
				consultaRemolcadoresServicio();
			}
		});
	}
	
}

function cosultaFechaHoraServer(){
	
	var fecahaHoraServer;	
	var json_request = {
		tipoOperacion: "consultaFechaHora"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {
			fecahaHoraServer = resp.fechaHora;
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
	
	return fecahaHoraServer;
}

function primerCaboInsertar(pBuque){

	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "primerCaboInsertar"
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {
			if(parseInt(resp.transaccion) === 1){
				//var pBody = formaEmail(1);
				var pBody = "Se adjunta reporte de primer cabo del buque: " + pBuque;
				primerCaboPDF();
				var pListaCorreosCliente = consultarCorreos("1");
				var pListaCorreosMovesa = consultarCorreosMoversa();
				
				var pListaCorreos = pListaCorreosCliente + pListaCorreosMovesa + ",whernandez@setiveracruz.com.mx";
				
				//pListaCorreos = "isc.ghernandez@gmail.com";
				console.log("pListaCorreos ->" + pListaCorreos);
													
				var json_request = {
					tipoOperacion: "enviarNotificacion"
					,pBody:pBody
					,pTipoNotificacion:'Primer cabo'
					,pBuque:pBuque
					,pListaCorreos:pListaCorreos
					,pNidServicio:pNidServicio
				};
				
				$.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/core/smtp/phpSendMail.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {						
						verDetalleServicio($("#hfNidServicio").val());	
						MessageBox(resp.transaccion, resp.mensaje);	
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error al enviar notificacion");
					},
					complete: function () {
						ajaxindicatorstop();
					}
				});
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, "Error al grabar la fecha-hora del primer cabo");
		}
	});
}




function validaServicioCompleto(){
	var generalesCompletos = validaDatos();
	
	var totalProa  = $tableProa.fnGetData().length;
	var totalPopa  = $tablePopa.fnGetData().length;
	
	var tablaPilotos = $("#tablaServicioPilotos").DataTable();
	var totalPilotos = tablaPilotos.data().count();

	var tableServicioRemolcadores = $('#tablaServicioRemolcadores').DataTable();
	var totalRemolcadores = tableServicioRemolcadores.data().count();
	
	var vTieneBitas = false;
	var vTieneDefensas = false;
	var vTienePintura = false;
	var vTieneSugercion = false;
	var vTieneParamento = false;
	
	
	if($('#checkBitasA').prop('checked') == true || $('#checkBitasB').prop('checked') == true){
		vTieneBitas = true;
	}
	
	if($('#checkDefensasA').prop('checked') == true || $('#checkDefensasB').prop('checked') == true){
		vTieneDefensas = true;
	}
	
	if($('#checkPinturaA').prop('checked') == true || $('#checkPinturaB').prop('checked') == true){
		vTienePintura = true;
	}
	
	if($('#checkSugercionA').prop('checked') == true || $('#checkSugercionB').prop('checked') == true){
		vTieneSugercion = true;
	}
	
	if($('#checkParamentoA').prop('checked') == true || $('#checkParamentoB').prop('checked') == true){
		vTieneParamento = true;
	}
	
	

	if(vTieneBitas && vTieneDefensas && vTienePintura && vTieneSugercion && vTieneParamento){
		if(generalesCompletos){
			if(parseInt(totalPilotos) > 0){
				if(parseInt(totalRemolcadores) > 0){
					if(parseInt(totalProa) > 0){
						if(parseInt(totalPopa) > 0){
							return true;
						}else{
							MessageBox('0', 'Debe ingresar el personal de POPA');
							return false;
						}
					}else{
						MessageBox('0', 'Debe ingresar el personal de PROA');
						return false;
					}
				}else{
					MessageBox('0', 'Debe ingresar los remolcadores que participaron en la maniobra');
					return false;
				}
			}else{
				MessageBox('0', 'Debe ingresar los pilotos que participarán en la maniobra');
				return false;
			}
		}else{
			MessageBox('0', 'Falta informacion general del servicio');
			return false;
		}
	}else{
		MessageBox('0', 'Falta informacion del estado de la posicion de atraque');
		return false;
	}

}

function bloquearControles(){
	$("#txtBuque").attr("disabled",true);
	$("#txtViaje").attr("disabled",true);
	$("#txtTrb").attr("disabled",true);
	$("#txtEslora").attr("disabled",true);
	$("#txtNaviera").attr("disabled",true);
	$("#txtEta").attr("disabled",true);
	$("#ddlMuelles").attr("disabled",true);
	$("#ddlTipoOperacion").attr("disabled",true);
	$("#ddlClientes").attr("disabled",true);
	$("#txtComentarios").attr("disabled",true);

	$("#txtViajeNaviera").attr("disabled",true);
	$("#ddlNaviera").attr("disabled",true);
	
	$('#checkBitasA').attr("disabled",true);
	$('#checkBitasB').attr("disabled",true);
	
	$('#checkDefensasA').attr("disabled",true);
	$('#checkDefensasB').attr("disabled",true);
	
	$('#checkPinturaA').attr("disabled",true);
	$('#checkPinturaB').attr("disabled",true);
	
	$('#checkSugercionA').attr("disabled",true);
	$('#checkSugercionB').attr("disabled",true);
	
	$('#checkParamentoA').attr("disabled",true);
	$('#checkParamentoB').attr("disabled",true);
	
	$('#btnPrimerCabo').attr("disabled",true);
	$('#btnUltimoCabo').attr("disabled",true);		
	
	$("#btnGuardar").hide();
	$("#btnCapturar").hide();
	$("#btnConsultaPilotos").hide();
	$("#btnConsultaRemolcadores").hide();
	$("#btnProa").hide();
	$("#btnPopa").hide();
	
	$("#btnEliminar").hide();
}


function puedeModificar(){
	
	var vRespuesta = false;
	
	var json_request = {
		tipoOperacion: "consultaRol"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/login.php",
		dataType: "json",
		async: false,
		success: function (resp) {			
			if(parseInt(resp.nid) === 3){
				vRespuesta = false;
				bloquearControles();
				MessageBox("error", "No tienen los permiso necesarios para realizar la acción...!!!");
			}else{
				vRespuesta = true;
			}
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
			
		}
	});		
	
	return vRespuesta;
}

// 1 -> Operativo, 2 -> Administrativo
function consultarCorreos(pTipo){
	var pCorreos = "";
	//var pNidCliente = $("#ddlClientes").val();
	//var pNombreCliente = $("#ddlClientes option[value='"+ pNidCliente +"']").text();
	//var pNaviera = $("#txtNaviera").val();
      
	/*if(pNaviera === pNombreCliente){
		pCorreos = consultarCorreosCliente(pTipo);
	}else{
		pCorreos = consultarCorreosNaviera(pTipo);
	}*/
	
	pCorreos = consultarCorreosCliente(pTipo);
		
	return pCorreos ;
}

function consultarCorreosCliente(pTipo){
	var pCorreos = "";
	//var pNidCliente = $("#ddlClientes").val();
	var pNidCliente = $("#ddlNaviera").val();
	  
	var json_request = {
		tipoOperacion: "consultaCorreos"            
		,pNidCliente:pNidCliente
		,pTipo:pTipo
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catCorreos.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				pCorreos = pCorreos + json.correo + ",";                    
			}				
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);			
		}
	});
		
	return pCorreos;
}

function consultarCorreosNaviera(pTipo){
	var pCorreos = "";
	var pNidCliente;
	var pNaviera = $("#txtNaviera").val();
	
	$("#ddlClientes > option").each(function() {		
		if(pNaviera === this.text){
			pNidCliente = this.value;
			var json_request = {
				tipoOperacion: "consultaCorreos"            
				,pNidCliente:pNidCliente
				,pTipo:pTipo
			};
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/catCorreos.php",
				dataType: "json",
				async: false,
				success: function (resp) {
					for (var i = 0; i < resp.datos.length; i++) {
						var json = resp.datos[i];					
						pCorreos = pCorreos + json.correo + ",";                    
					}				
				},
				error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);			
				}
			});
		}		
	});
	  
	return pCorreos ;
}


function consultarCorreosMoversa(){
	var pCorreos = "";
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catCorreosMoversa.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				pCorreos = pCorreos + json.correo + ",";                    
			}				
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);			
		}
	});
		
	return pCorreos ;
}

function consultarConceptos(){
      $("#ddlTipoOperacion").empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catConceptos.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			
			$("#ddlTipoOperacion").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlTipoOperacion").append('<option value="'+ json.nid +'">'+ json.concepto +'</option>');                    
			}				
		}
	});
}


function cerrarUltimoCabo(){
	$("#divPregunta").hide();
	$("#divResultado").show();
	$("#btnCapturarUltimoCabo").hide();

	ultimoCaboInsertar();
}

function ultimoCaboInsertar(){

	var pNidServicio = $("#hfNidServicio").val();
	var vTipoServicio = $("#ddlTipoOperacion").val();
	
	var json_request = {
		tipoOperacion: "ultimoCaboInsertar"
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {	
			console.log("Response ultimoCaboInsertar");
			console.log(resp);
		
			$("#txtUltimoCabo").val(resp.mensaje);	
         
			if(parseInt(resp.transaccion) === 1){	
			    ultimoCaboPDF();
			    verDetalleServicioTerminado(pNidServicio);

				var json_requestA = {
					tipoOperacion: "validaFacturacion"
					,pNidServicio:pNidServicio
				};
				
				$.ajax({
					type: "POST",
					data: json_requestA,
					url: "../moversa/dataAccess/serviciosProgramados.php",
					dataType: "json",
					async: true,
					success: function (data) {			
						console.log("Response arma factura en BD");
						console.log(data);

						if(parseInt(data.transaccion) === 1){	
							$("#txtFactura").val(data.mensaje + "\r\n" + "Se procede a facturar el servicio") + "\r\n";
												
							timbrarFactura(1, 1, data.nid)
						}else{
							$("#txtFactura").val(data.mensaje + "\r\n" + "El servicio fue enviado a la bandeja de terminados");
						}

						bloquearControles();
						$("btnGuardar").hide();
						vPuedeModificar = false;
						consultaXestado(); //Ejecutamos consulta nuevamente
					},
					complete: function () {
						//Mandamos notificacion via correo electronico
						
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error al generar factura en BD");
					}
				});
			}else{
				MessageBox(resp.transaccion, resp.mensaje);
			}

			
		},
	    complete: function () {
				//Si actualizo fecha de ultimo cabo se actualizao el DOM
		    //verDetalleServicio($("#hfNidServicio").val());
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, "Error grabar la fecha-hora del ultimo cabo");
		}
	});
}


async function ultimoCaboPDF(){
	
	var pHtml = formaEmailUltimoCabo(2);
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "ultimoCaboPDF",
		pNidServicio:pNidServicio,
		pHtml: pHtml
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			if(parseInt(resp.transaccion) === 1){
				var pBuque = $("#txtBuque").val();
				var pNidServicio = $("#hfNidServicio").val();
			
				var pBody = "Se adjunta reporte de ultimo cabo del buque: " + pBuque;
				var pListaCorreosCliente = consultarCorreos("1");						
				var pListaCorreosMovesa = consultarCorreosMoversa();
				console.log("pListaCorreosCliente");
				console.log("Correos ->" + pListaCorreosCliente);
				
				var pListaCorreos = pListaCorreosCliente + pListaCorreosMovesa + ",whernandez@setiveracruz.com.mx";
				
				//pListaCorreos = "whernandez@setiveracruz.com.mx";
				console.log("pListaCorreos ->" + pListaCorreos);
							  
				var json_request = {
					tipoOperacion: "enviarNotificacionUltimoCabo"
					,pBody:pBody
					,pTipoNotificacion:'Ultimo cabo'
					,pBuque:pBuque
					,pListaCorreos:pListaCorreos
					,pNidServicio:pNidServicio
				};
			   
				$.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/core/smtp/phpSendMail.php",
					dataType: "json",
					async: false,
					success: function (resp) {	
						$("#txtNotificacion").val(resp.mensaje);
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error al enviar notificacion");
					},
					complete: function () {
						//sleep(2000);
						ajaxindicatorstop();
					}
				});				
			}else{
				MessageBox(0, "Error al generar PDF para la notificacion");
			}		
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, "Error al generar PDF para la notificacion");
		}
	});
}


function servicioEstadoCambiar(pNidEstado){
	var pNidServicio = $("#hfNidServicio").val();
		
	var json_request = {
		tipoOperacion: "cambiarEstado",
		pNidServicio:pNidServicio,
		pNidEstado:pNidEstado
	};
   
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {						
			//MessageBox(resp.transaccion, resp.mensaje);	
		},
		complete: function () {
			consultaXestado();
			verGeneralServicio();
		},error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
		}
	});
}

async function sleep(ms) {
	return new Promise(resolve => setTimeout(resolve, ms));
}



function eliminarFacturaAmarres(pIdFactura){
	console.log("eliminarFacturaAmarres, Factura -->" + pIdFactura);
	var datos = {
		pTipoOperacion: "eliminarFactura",
		pTipoSistema: "1",
		pIdFactura: pIdFactura
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log("--> Resultado eliminarFacturaPlataforma");
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}
