
var $tableBuques;
var $tablePersonal;

var $datosJson;

var $tablePersonalProa; //Catalogo personal proa
var $tablePersonalPopa; //Catalogo personal popa

var $tableProa; //Tabla de personal agregado
var $tablePopa; //Tabla de personal agregado

var $tableRemolcadores;
var $tablePilotos;

var $tableServiciosTerminados;
var $tableServiciosFacturado;
var $tableServiciosPendiente;

var $tableServicioRemolcadores;
var $tableServicioPilotos;


var cameras = new Array(); //create empty array to later insert available devices

$("document").ready(function () {
	$('.select2').select2({
        theme: 'bootstrap4'
    })
	
	consultarClientes();
	
	$("#linkTerminados").addClass("subdrop");
   	//Iniciamos TABS
	$( "#tabs" ).tabs();
	$( "#tabsPrincipal" ).tabs();
	
   	inicialiaValores();
	$.getScript("../moversa/assets/js/icheckTable.js");


});


function inicialiaValores(){
	
	consultaServiciosTerminados();
	consultaServiciosFacturados();
	//consultaServiciosPendientes();
		
	//Asignamos Tablas a variables
	$table = $("#tablaBuquesProgramados");
	$tablePersonal = $("#tablaPersonal");
	$tablePersonalProa = $("#tablaPersonalProa");
	$tablePersonalPopa = $("#tablaPersonalPopa");
	$tableRemolcadores = $("#tablaRemolcadores");
	$tablePilotos = $("#tablaPilotos");
	
		
	$tableServiciosTerminados = $("#tablaServiciosTerminados");
	$tableServiciosFacturado = $("#tablaServiciosFacturados");
	$tableServiciosPendiente = $("#tablaServiciosPendientes");
	
	
	$tableProa = $('#tablaProa');
	$tablePopa = $('#tablaPopa');
	
	$tableServicioRemolcadores = $('#tablaServicioRemolcadores');
	$tableServicioPilotos = $('#tablaServicioPilotos');
		
	//Iniciamos Fechas
	$('input[id$=txtEta]').datetimepicker({
        format: 'd/m/Y H:m',
        lang: 'es',
        mask: true,
        timepicker: true
    });
	
	$('input[id$=txtFechaPago]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
		
	$("#btnGuardar").click(function(){ imprimirProforma(); });	
	$("#btnRegresar").click(function(){ verGeneralServicio(); });	
	$("#btnProforma").click(function(){ imprimirProforma(); });	
	$("#btnServicio").click(function(){ imprimeServicio(); });	
	$("#btnArmaProforma").click(function(){ armaProforma(); });
	$("#btnEnviarProforma").click(function(){ enviarProforma(); });
	$("#btnActualizar").click(function(){ ventanaActualizar(); });	
	$("#btnFacturar").click(function(){ iniciaFacturacion(); });
	$("#btnFacturarServicio").click(function(){ facturarServicio(); });	
	$("#btnGuardarCambios").click(function(){ guardarCambios(); });
	$("#btnVentanaPagar").click(function(){ ventanaPagar(); });
	$("#btnGenerarComplemento").click(function(){ generarComplemento(); });
	
	consultarFormasPago();
}

function apagarCamara(){
	Webcam.reset();
}


function consultarPersonal(){
      
	var json_request = {
		tipoOperacion: "consultaServiciosTerminados"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);
			
			    for (var i = 0; i < resp.datos.length; i++) {

                    var json = resp.datos[i];

                    $tablePersonal.append('<tr>' +
                        '    <td class="a-center "><input type="checkbox" class="flat" name="table_records"></td>' +
                        '    <td> <input id="hfNidUnidad" type="hidden" value="' + json.nid + '" /> <span id="spanCodigo">' + json.nombre + '</span></td>' +
                        '    <td>' + json.paterno + '</td>' +
                        '    <td>' + json.materno + '</td>' +
                        '    <td>' + json.puesto + '</td>' +
                        '</tr>');
                }
					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function consultaServiciosTerminados(){
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"2"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			
			$tableServiciosTerminados.DataTable().clear().draw();
			$tableServiciosTerminados.dataTable().fnDestroy();
			$tableServiciosTerminados.DataTable({
				data: resp.datos,
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				info:false,
				paging:false,
				searching:true,
				columns: [
					{						
						"data": "viaje",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vImo = oData.imo;
							$(nTd).html("<span><a id='linkViaje' href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
						}
					},
					{
						
						"data": "servicioAmarre",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {							
							$(nTd).html("<span>AMA"+ sData +"</span>");
						}
					},
					{ "data": "buque" },
					{ "data": "eta" },
					{ "data": "naviera" },
					{ "data": "tipoServicio" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vBuque = "'" + oData.buque + "'";
							var vNidProforma = oData.nidProforma;
							
							$(nTd).html('<span><a href="#" onclick="verDetalleServicio(' + sData + ','+ vBuque + ',' + vNidProforma +',2)"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});	

			$.getScript("../moversa/assets/js/icheckTable.js");					
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function muestraMarineTrafic(pImo) {
	localStorage.setItem("pImoConsultar", pImo);
	location.href = "/moversa/account.php?page=mapa";
}

function verDetalleServicio(pNidServicio, pBuque, pNidProforma, pEstado){
	$("#hfNidServicio").val(pNidServicio);
	$("#hfNidProforma").val(pNidProforma);
	
	$("#divGenerales").hide();
	$("#divDetalle").show();
	
	$("#spanBuqueProforma").text(pBuque);

	consultaPosicionServicio();
	
	if(pEstado === 2){
		$("#btnActualizar").show();
		$("#btnFacturar").show();
	}else if(pEstado === 3){
		$("#btnActualizar").hide();
		$("#btnFacturar").hide();
		
	}
	
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:pEstado
	};

	console.log(json_request);
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				
				if(parseInt(json.nid) === parseInt(pNidServicio)){
					$("#spanFolio").text('AMA' + json.servicioAmarre);
					$("#spanBuque").text(json.buque);
					$("#spanViaje").text(json.viaje);
					$("#spanTRB").text(json.trb);
					$("#spanEslora").text(json.eslora);
					$("#spanNaviera").text(json.naviera);
					$("#spanETA").text(json.eta);
					$("#spanMuelle").text(json.muelle);
					$("#spanOperacion").text(json.tipoServicio);
					$("#spanCliente").text(json.cliente);
					$("#hfNidCliente").val(json.nidCliente);
					$("#spanViajeCliente").text(json.viajeNaviera);
					$("#spanObservaciones").text(json.observaciones);					

					$("#spanBuqueProf").text(json.buque);
					$("#spanViajeProf").text(json.viaje);
					$("#spanTRBProf").text(json.trb);
					$("#spanEsloraProf").text(json.eslora);
					$("#spanNavieraProf").text(json.naviera);
					$("#spanETAProf").text(json.eta);
					$("#spanMuelleProf").text(json.muelle);
					$("#spanOperacionProf").text(json.tipoServicio);
					$("#spanClienteProf").text(json.cliente);
					$("#spanTotalProf").text(json.costo);			
					
					$("#spanPrimerCabo").text(json.primerCabo);
					$("#spanUltimoCabo").text(json.ultimoCabo);
					
					$("#spanFolioProf").text(json.nid);
					$("#spanPrimerCaboProf").text(json.primerCabo);
					$("#spanUltimoCaboProf").text(json.ultimoCabo);
					$("#spanFolioFactura").text(json.nidFactura);
					
				}
			}				
		},
		complete: function () {
			ajaxindicatorstop();
			consultaPersonalServicio(1);
			consultaPersonalServicio(2);
			
			consultaPilotosServicio();
			consultaRemolcadoresServicio();
			cargarArchivos();
			consultaCliente();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function consultaCliente(){
	
	var pNidCliente = $("#hfNidCliente").val();
		
	var json_request = {
		tipoOperacion: "consultaCliente"            
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		success: function (resp) {  

			var json = resp.datos[0];
			
			$("#spanNombreClienteProf").text(json.razonsocial);
			$("#spanRFCProf").text(json.rfc);
			$("#spanDireccionProf").text(json.domicilio);
			$("#spanCpProf").text(json.rfc);		
			
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function verGeneralServicio(){
	$("#divGenerales").show();
	$("#divDetalle").hide();
}


function consultaPersonalServicio(pNidPosicion){
	
	
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaPersonalServicio"            
		,pNidServicio:pNidServicio
		,pNidPosicion:pNidPosicion
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		success: function (resp) {

			if(parseInt(pNidPosicion) === 1){	
				$('#tablaProa tbody').empty();
			
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#tablaProa").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
				}	
			}else{
				$('#tablaPopa tbody').empty();
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#tablaPopa").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
				}
			}				
		}
	});
}

function consultaPilotosServicio(){
	$('#tablaServicioPilotos tbody').empty();
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaPilotosServicio"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#tablaServicioPilotos").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
			}
		}
	});
}

function consultaRemolcadoresServicio(){
	$('#tablaServicioRemolcadores tbody').empty();
	var pNidServicio = $("#hfNidServicio").val();
	
	var json_request = {
		tipoOperacion: "consultaRemolcadoresServicio"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#tablaServicioRemolcadores").append('<tr><td><i class="fa fa-arrow-right" style="padding-right: 10px;padding-left: 10px;"></i>'+ json.nombre +'</td></tr>');
			}	
		}
	});
}

function consultaPosicionServicio(){
	
	var pNidServicio = $("#hfNidServicio").val();
		
	var json_request = {
		tipoOperacion: "posicionConsultar"            
		,pNidServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {
			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];	
				
				//Bitas
				if(parseInt(json.nid) === 1){
					if(parseInt(json.estado) === 1){
						$("#spanBitas").text("Ok");
					}else{
						$("#spanBitas").text("Daño");
					}
				}
				
				//Defensa
				if(parseInt(json.nid) === 2){
					if(parseInt(json.estado) === 1){
						$("#spanDefensas").text("Ok");
					}else{
						$("#spanDefensas").text("Daño");
					}
				}
				
				//Pintura
				if(parseInt(json.nid) === 3){
					if(parseInt(json.estado) === 1){
						$("#spanPintura").text("Ok");
					}else{
						$("#spanPintura").text("Daño");
					}
				}
				
				//Sugercion
				if(parseInt(json.nid) === 4){
					if(parseInt(json.estado) === 1){
						$("#spanSugercion").text("Ok");
					}else{
						$("#spanSugercion").text("Daño");
					}
				}
				
				//Paramento
				if(parseInt(json.nid) === 5){
					if(parseInt(json.estado) === 1){
						$("#spanParamento").text("Ok");
					}else{
						$("#spanParamento").text("Daño");
					}
				}
			
			}

		}
	});
}


function consultarCorreos(pTipo){
	var pCorreos = "";
	var pNidCliente = $("#hfNidCliente").val();
	

	var json_request = {
		tipoOperacion: "consultaCorreos"            
		,pNidCliente:pNidCliente
		,pTipo:pTipo
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catCorreos.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				pCorreos = pCorreos + json.correo + ",";                    
			}				
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);			
		}
	});
	return pCorreos;
}

function cargarArchivos(){
	var pNidServicio = $("#hfNidServicio").val();
	$("#divFotografias").empty();
      
	var json_request = {
		tipoOperacion: "consultaArchivos"            
		,pServicio:pNidServicio
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) { 

			console.log(resp);
			if(resp.datos != null){
				for (var i = 0; i < resp.datos.length; i++) {
					var json = resp.datos[i];					
					$("#divFotografias").append('<a data-fancybox="gallery" href="dataAccess/'+ json.nombre +'" class="col-sm-2">'+
												'	<img src="dataAccess/'+ json.nombre +'" class="img-fluid">'+
												'</a>');
				}	
			}	
						
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}


function consultaServiciosFacturados(){
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"3" //Facturados
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			
			$tableServiciosFacturado.DataTable().clear().draw();
			$tableServiciosFacturado.dataTable().fnDestroy();
			$tableServiciosFacturado.DataTable({
				data: resp.datos,
				"language": JSON.parse(lenguaje),
				"autoWidth": false,
				info:false,
				paging:false,
				searching:true,
				columns: [{
								"data": "nid",
								"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
									var vNidCliente =oData.nidCliente;
									var vNidFactura =oData.nidFactura;
									var vNidFolioLocal =oData.nidFolioLocal;
									var vUuid = oData.uuid;

									$(nTd).html('<span><input type="checkbox" class="flat" name="table_records"><input id="hfNidServicio" type="hidden" value="' + sData + '" /><input id="hfNidClienteFactura" type="hidden" value="' + vNidCliente + '" /><input id="hfNidFactura" type="hidden" value="' + vNidFolioLocal + '" /><input id="hfUuid" type="hidden" value="' + vUuid + '" /></span>');
								}
							}, 
					{
						
						"data": "servicioAmarre",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {							
							$(nTd).html("<span>AMA"+ sData +"</span>");
						}
					},
					{"data": "nidFactura", "Width":"20px"},
					{
						
						"data": "viaje",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vImo = oData.imo;
							$(nTd).html("<span><a id='linkViaje' href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
						}
					},
					{ "data": "buque" },
					{ "data": "eta" },
					{ "data": "naviera" },
					{ "data": "tipoServicio" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vBuque = "'" + oData.buque + "'";
							var vNidProforma = oData.nidProforma;
							$(nTd).html('<span><a href="#" onclick="verDetalleServicio(' + sData + ','+ vBuque + ',' + vNidProforma + ',3)"><i class="fa fa-check-square fa-2x" style="padding-left: 10px;"></i></a></span>');
						}
					}
				]
			});		
			
			$.getScript("../moversa/assets/js/icheckTable.js");
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}


function imprimeServicio(){
	
	//var vServicio = $("#tabServicio").html();
	var pNidServicio = $("#hfNidServicio").val();
	var pBuque = $("#spanBuque").text();
	var pHtml = formaHtmlServicio(-1);
	
	var json_request = {
		tipoOperacion: "imprimirServicio",
		pNidServicio:pNidServicio,
		pHtmlProforma: pHtml
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);				
		},complete: function () {
			ajaxindicatorstop();
			$("#iframepdfServicio").attr("src","/moversa/dataAccess/servicios/" + pNidServicio+ ".pdf");
			$("#popupServicio").modal("show");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});	
}



function consultarUsoCFDI(){
      
	$("#ddlUsoCFDI").empty();
	
	var json_request = {
		tipoOperacion: "consultaServiciosTerminadosUso"            
		,pEstado:"0"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catFiscales.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			
			$("#ddlUsoCFDI").append('<option value="-1">- Seleccione -</option>'); 
			//$("#ddlUsoCFDI").append('<option value="'+ claveuso +'">'+ descripcionuso +' - '+ descripcionuso +'</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlUsoCFDI").append('<option value="'+ json.nid +'">'+ json.claveuso +' - '+ json.descripcionuso +'</option>');                    
			}	
		}
	});
}

function consultarFormaPago(){
      
	$("#ddlFormaPago").empty();
	
	var json_request = {
		tipoOperacion: "consultaServiciosTerminadosForma"            
		,pEstado:"0"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catFiscales.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			
			$("#ddlFormaPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlFormaPago").append('<option value="'+ json.nid +'">'+ json.formapago +' - '+ json.descripcionforma +'</option>');                    
			}	
		}
	});
}

function consultarMetodoPago(){
      
	$("#ddlMetodoPago").empty();
	
	var json_request = {
		tipoOperacion: "consultaServiciosTerminadosMetodo"            
		,pEstado:"0"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catFiscales.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			
			$("#ddlMetodoPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlMetodoPago").append('<option value="'+ json.nid +'">'+ json.metodopago +' - '+ json.descripcionmetodo +'</option>');                    
			}	
		}
	});
}
			
//fin pruebas de datos fiscales

function consultarCorreosMoversa(){
	var pCorreos = "";
      
	var json_request = {
		tipoOperacion: "consultaServiciosTerminados"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catCorreosMoversa.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				pCorreos = pCorreos + json.correo + ",";                    
			}				
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);			
		}
	});
		
	return pCorreos ;
}

function buscaNidClienteServicio(pNidServicio){
	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"2"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				
				if(parseInt(pNidServicio) === parseInt(json.nid)){
					$("#hfNidCliente").val(json.nidCliente);
				}
			}							
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);	
		}
	});
}

function consultaClienteConfiguracion(pNidCliente){
			
	var json_request = {
		tipoOperacion: "consultaClienteConfiguracion"            
		,pNidCliente:pNidCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {  

			var json = resp.datos[0];
						
			if(parseInt(json.nidUsoCFDI) != 0){
			    $("#ddlUsoCFDI").val(json.nidUsoCFDI);
    			$("#ddlMetodoPago").val(json.nidMetodoPago);
    			$("#ddlFormaPago").val(json.nidFormaPago);
			}else{
			    $("#ddlUsoCFDI").val("-1");
    			$("#ddlMetodoPago").val("-1");
    			$("#ddlFormaPago").val("-1");
			}
		},
		complete: function () {
			ajaxindicatorstop();
			cargarArchivos();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function ventanaActualizar(){

	var pNidServicio = $("#hfNidServicio").val();

	var json_request = {
		tipoOperacion: "consultarXestado"            
		,pEstado:"2"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		success: function (resp) {             			
			console.log("serviciosProgramados");
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				
				if(parseInt(json.nid) === parseInt(pNidServicio)){
					$("#txtViajeNaviera").val(json.viajeNaviera);
					//$("#ddlCliente").val(json.nidCliente);
					$("#txtComentarios").val(json.observaciones);
					
					/*$("#ddlCliente option").filter(function() {
						return this.text == ojson.nidCliente; 
					}).attr('selected', true);*/
					
					//$('#ddlCliente').trigger('change'); // Notify any JS components that the value changed
				}
				
			}				
		}
	});

	$("#popupModificar").modal("show");
}

function consultarClientes(){
	$("#ddlCliente").empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catClientes.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlCliente").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlCliente").append('<option value="'+ json.nid +'">'+ json.nombrecorto +'</option>');
			}			
		}
	});
}


function guardarCambios(){
		var pNidServicio = $("#hfNidServicio").val();
		var pViajeNaviera = $("#txtViajeNaviera").val();
		var pNidCliente = $("#ddlCliente").val();
		var pComentarios = $("#txtComentarios").val();
		
		if(validaDatos()){
				var json_request = {
					tipoOperacion: "actualizaServicioTerminado" 
					,pNidServicio:pNidServicio
					,pViajeNaviera:pViajeNaviera
					,pNidCliente:pNidCliente
					,pComentarios:pComentarios
				};				
				
				$.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/serviciosTerminados.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						//console.log(resp);								
						MessageBox(resp.transaccion, resp.mensaje);
					},
					complete: function () {
						ajaxindicatorstop();
						$("#popupModificar").modal("hide");
						//consultar();

						 verDetalleServicio($("#hfNidServicio").val(), $("#spanBuqueProforma").text(), 0, 2);							
					},
					error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
					}
				});
		}
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var pViajeNaviera = $("#txtViajeNaviera").val();
	var pNidCliente = $("#ddlCliente").val();
	var pComentarios = $("#txtComentarios").val();
	
	if(parseInt(pNidCliente) === -1 ){
        $("#ddlCliente").addClass('campo-requerido');
        respuesta=false;
    }	
	
	if(pViajeNaviera.length === 0){
        $("#txtViajeNaviera").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(pComentarios.length === 0){
        $("#txtComentarios").addClass('campo-requerido');
        respuesta=false;
    }
		
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}

function iniciaFacturacion(){	
	$("#divPregunta").show();
	$("#divResultado").hide();
	$("#txtFactura").val("");
	$("#btnFacturarServicio").show();
	
	$("#popupFactura").modal("show");
}

async function facturarServicio(){

	$("#divPregunta").hide();
	$("#divResultado").show();
	$("#btnFacturarServicio").hide();
	var pNidServicio = $("#hfNidServicio").val();
	ajaxindicatorstart();

	await sleep(2000);

	var json_request = {
		tipoOperacion: "validaFacturacion"
		,pNidServicio:pNidServicio
	};

	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosProgramados.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (data) {	

			console.log(data);								
			if(parseInt(data.transaccion) === 1){	
				$("#txtFactura").val(data.mensaje + "\r\n" + "Se procede a facturar el servicio") + "\r\n";
				timbrarFactura(1, 1, data.nid)

				$("#btnActualizar").hide();
				$("#btnFacturar").hide();				
			}else{
				$("#txtFactura").val(data.mensaje);
				$("#spanResultadoFacturacion").append('<i class="fa fa-close" aria-hidden="true" style="font-size: 20px;color:red;"></i>');
				ajaxindicatorstop();
			}

		},
		complete: function () {
			//ajaxindicatorstop();					
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function sleep(ms) {
	return new Promise(resolve => setTimeout(resolve, ms));
  }

  function servicioCambiarFacturado(){
	$("#tablaServiciosFacturados tbody tr").each(function () {
		if ($(this).find("input[type=checkbox]").is(':checked')) {
			var pNidServicio = $(this).find("#hfNidServicio").val();
			
			var json_request = {
				tipoOperacion: "cambiarEstado",
				pNidServicio:pNidServicio,
				pNidEstado:"6"
			};
		
		   
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosTerminados.php",
				dataType: "json",
				async: false,
				beforeSend: function () {
					ajaxindicatorstart();
				},
				success: function (resp) {						
					//MessageBox(resp.transaccion, resp.mensaje);	
				},
				complete: function () {
					//consultaServiciosTerminados();
					consultaServiciosFacturados();
				},error: function (xhr, ajaxOptions, thrownError) {
						console.log(xhr);
						console.log(ajaxOptions);
						console.log(thrownError);
				}
			});
		}
	});
  }

  function servicioEstadoCambiar(pNidEstado){
	var pNidServicio = $("#hfNidServicio").val();
		
	var json_request = {
		tipoOperacion: "cambiarEstado",
		pNidServicio:pNidServicio,
		pNidEstado:pNidEstado
	};

   
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {						
			//MessageBox(resp.transaccion, resp.mensaje);	
		},
		complete: function () {
			consultaServiciosTerminados();
			consultaServiciosFacturados();
		},error: function (xhr, ajaxOptions, thrownError) {
				console.log(xhr);
				console.log(ajaxOptions);
				console.log(thrownError);
		}
	});
}

function ventanaPagar(){
	
	var vMismoCliente=true;
	var vClienteSeleccionado=0;
	//var vCliente;
	var totalRegistrosSeleccionados = 0;
	var vNidCliente=0;
	
	$("#tablaServiciosFacturados tbody tr").each(function () {
        if ($(this).find("input[type=checkbox]").is(':checked')) {
            var nid = $(this).find("#hfNidServicio").val();
			vNidCliente = $(this).find("#hfNidClienteFactura").val();
			//vViaje = $(this).find("#linkViaje").text();
			
			if(parseInt(vClienteSeleccionado) > 0){				
				if(parseInt(vNidCliente) === parseInt(vClienteSeleccionado)){
					vClienteSeleccionado = vNidCliente;
				}else{
					vMismoCliente = false;					
				}				
				
			}else{
				vClienteSeleccionado = vNidCliente;
			}	

			totalRegistrosSeleccionados =  totalRegistrosSeleccionados + 1;
        }		
    });
	
	if(parseInt(totalRegistrosSeleccionados) > 0){
		if(vMismoCliente){			
			$("#popupDatosComplementoPago").modal("show");
			$("#hfNidCliente").val(vNidCliente);
			limpiarCamposComplementos();
		}else{
			MessageBox(0, "Debe seleccionar servicios del mismo cliente...!!!");	
		}
	}else{
		MessageBox(0, "Debe seleccionar un viaje...!!!");	
	}
}

function consultarFormasPago(){
    $("#ddlFormasPago").empty();
	  
	var json_request = {
		tipoOperacion: "consultaXestado"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catFormasPago.php",
		dataType: "json",
		async: false,
		success: function (resp) {             
			$("#ddlFormasPago").append('<option value="-1">- Seleccione -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlFormasPago").append('<option value="'+ json.nid +'">'+ json.clave +'-'+ json.descripcion +'</option>');                    
			}				
		}
	});
}

function generarComplemento(){
	var vGeneroComplemento = true;
    var pNidComplemento = 0;
    var pMensaje = "";

	var pNidCliente = $("#hfNidCliente").val();
	var pMonto = $("#txtMonto").val();
	var pFechaPago = $("#txtFechaPago").val();
	var pNumOperacion = $("#txtNumOperacion").val();
	var pBancoOrdentante = $("#txtBancoOrdenante").val();
	var pFormasPago = $("#ddlFormasPago").val();
	var pRfcOrdenante = $("#txtRfcOrdenante").val();
	var pCuentaOrdenante = $("#txtCuentaOrdenante").val();
	var pRfcBeneficiario = $("#txtRfcBeneficiario").val();
	var pCuentaBeneficiario = $("#txtCuentaBeneficiario").val();
	
	if(validaDatosComplemento()){
			var json_request = {
				tipoOperacion: "complementoPagoInsertar" 
				,pNidCliente:pNidCliente
				,pMonto:pMonto
				,pFechaPago:pFechaPago
				,pNumOperacion:pNumOperacion
				,pBancoOrdentante:pBancoOrdentante
				,pFormasPago:pFormasPago
				,pRfcOrdenante:pRfcOrdenante
				,pCuentaOrdenante:pCuentaOrdenante
				,pRfcBeneficiario:pRfcBeneficiario
				,pCuentaBeneficiario:pCuentaBeneficiario
			};	
			
			console.log("Parametros complementoPagoInsertar");
			console.log(json_request);
			
			
			$.ajax({
				type: "POST",
				data: json_request,
				url: "../moversa/dataAccess/serviciosTerminados.php",
				dataType: "json",
				async: false,
				beforeSend: function () {
					ajaxindicatorstart();
				},
				success: function (resp) {             

					console.log(resp);
					
					if(parseInt(resp.transaccion) === 1){
					    
					    pNidComplemento = resp.nid;
					
						$("#tablaServiciosFacturados tbody tr").each(function () {
							if ($(this).find("input[type=checkbox]").is(':checked')) {

								var pNidFactura = $(this).find("#hfNidFactura").val();
								var pUuid = $(this).find("#hfUuid").val();

								var json_request = {
									tipoOperacion: "complementoPagoInsertarDetalle" 
									,pNidComplemento:resp.nid
									,pNidFactura:pNidFactura
									,pUuid:pUuid
								};		
								
								console.log(json_request);
								
								$.ajax({
									type: "POST",
									data: json_request,
									url: "../moversa/dataAccess/serviciosTerminados.php",
									dataType: "json",
									async: false,
									beforeSend: function () {
										ajaxindicatorstart();
									},
									success: function (resp) {             
										console.log(resp);

										if(parseInt(resp.transaccion) === 0){
											vGeneroComplemento = false;
											pMensaje = resp.mensaje;
										}

									},
									complete: function () {
										//ajaxindicatorstop();						
									},
									error: function (xhr, ajaxOptions, thrownError) {
										console.log(xhr);
										console.log(ajaxOptions);
										console.log(thrownError);
									}
								});
							}					
						});

						if(vGeneroComplemento){
							timbrarComplemento(1,1,resp.nid);
						}else{
							MessageBox(0, "ERROR AL GENERAR COMPLEMENTO: " + pMensaje);
							
							//Si truena el insertar complemento detalle - se elimina el registro
							eliminarComplemento(pNidComplemento);
						}
					}
					else{
						MessageBox(resp.transaccion, resp.mensaje);
					}
				},
				complete: function () {
					ajaxindicatorstop();
					$("#popupModificar").modal("hide");
					//consultar();

					 //verDetalleServicio($("#hfNidServicio").val(), $("#spanBuqueProforma").text(), 0, 2);							
				},
				error: function (xhr, ajaxOptions, thrownError) {
					console.log(xhr);
					console.log(ajaxOptions);
					console.log(thrownError);
				}
			});
	}
}

function validaDatosComplemento(){
	var respuesta=true;
    var mensaje="";
	
	var pMonto = $("#txtMonto").val();
	var pFechaPago = $("#txtFechaPago").val();
	var pNumOperacion = $("#txtNumOperacion").val();
	var pBancoOrdentante = $("#txtBancoOrdenante").val();
	var pFormasPago = $("#ddlFormasPago").val();
	var pRfcOrdenante = $("#txtRfcOrdenante").val();
	var pCuentaOrdenante = $("#txtCuentaOrdenante").val();
	var pRfcBeneficiario = $("#txtRfcBeneficiario").val();
	var pCuentaBeneficiario = $("#txtCuentaBeneficiario").val();

	if(pRfcBeneficiario.length === 0){
        if(pCuentaBeneficiario.length > 0){
			$("#txtRfcBeneficiario").addClass('campo-requerido');
			respuesta=false;
		}
    }else{
		if(pCuentaBeneficiario.length === 0){
			$("#txtCuentaBeneficiario").addClass('campo-requerido');
			respuesta=false;
		}else{
			var tamCuenta= pCuentaBeneficiario.length;

			if(tamCuenta != 10 && tamCuenta != 16 && tamCuenta != 18){
				$("#txtCuentaBeneficiario").addClass('campo-requerido');
				respuesta=false;
			}
		}
	}


	if(pRfcOrdenante.length === 0){
        if(pCuentaOrdenante.length > 0){
			$("#txtRfcOrdenante").addClass('campo-requerido');
			respuesta=false;
		}
    }else{
		if(pCuentaOrdenante.length === 0){
			$("#txtCuentaOrdenante").addClass('campo-requerido');
			respuesta=false;
		}else{
			var tamCuenta= pCuentaOrdenante.length;

			if(tamCuenta != 10 && tamCuenta != 16 && tamCuenta != 18){
				$("#txtCuentaOrdenante").addClass('campo-requerido');
				respuesta=false;
			}
		}
	}

	/*if(pNumOperacion.length === 0){
        $("#txtNumOperacion").addClass('campo-requerido');
        respuesta=false;
    }*/

	/*if(pBancoOrdentante.length === 0){
        $("#txtBancoOrdenante").addClass('campo-requerido');
        respuesta=false;
    }*/

	if(parseInt(pFormasPago) === -1 ){
        $("#ddlFormasPago").addClass('campo-requerido');
        respuesta=false;
    }	
	
	/*if(pMonto.length === 0){
        $("#txtMonto").addClass('campo-requerido');
        respuesta=false;
    }*/
	
	if(pFechaPago.length === 0){
        $("#txtFechaPago").addClass('campo-requerido');
        respuesta=false;
    }
		
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar o el campo no cumple con los requerimientos", "error");
    }
    
    return respuesta;
}

function limpiarCamposComplementos(){
	$("#txtMonto").val("");
	$("#txtFechaPago").val("");
	$("#txtNumOperacion").val("");
	$("#txtBancoOrdenante").val("");
	$("#ddlFormasPago").val("-1");
	$("#txtRfcOrdenante").val("");
	$("#txtCuentaOrdenante").val("");
	$("#txtRfcBeneficiario").val("");
	$("#txtCuentaBeneficiario").val("");
}


function cancelarFactura(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "La factura será cancelada";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    /*var json_request = {
					tipoOperacion: "eliminarUsuario"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../moversa/dataAccess/catUsuarios.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {             
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
						ajaxindicatorstop();
						consultar();
						$("#modal_add_user").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});*/
		
		  }
		});
}

function eliminarFacturaAmarres(pIdFactura){
	console.log("eliminarFacturaAmarres, Factura -->" + pIdFactura);
	var datos = {
		tipoOperacion: "eliminarFactura",
		pTipoSistema: "1",
		pIdFactura: pIdFactura
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log("--> Resultado eliminarFacturaPlataforma");
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}

function eliminarComplemento(pIdFolioComp){
	console.log("eliminarComplemento, IdComplemento -->" + pIdFolioComp);
	var datos = {
		tipoOperacion: "eliminarComplemento",
		pTipoSistema: "1",
		pIdFolioComp: pIdFolioComp
	};
	
	$.ajax({
		type: "POST",
		data: datos,
		url: "../moversa/dataAccess/serviciosTerminados.php",
		dataType: "json",
		async: false,
		success: function (resp) { 
			console.log("Resultado eliminar complemento");
			console.log(resp);
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
		}
	});
}