<?php

/*
  Created on : Mayo 26, 2019, 01:14:34 PM
  Author     : Gabriel Hernandez Gonzalez
 */
 
	require_once "../core/core_classes.php";
	require_once "../config.php";

	switch (filter_input(INPUT_POST, 'tipoOperacion')) {

		case 'guardar':
			
			$vNidCliente = filter_input(INPUT_POST, 'vNidCliente');
			$vTrbInicial = filter_input(INPUT_POST, 'vTrbInicial');
			$vTrbFinal = filter_input(INPUT_POST, 'vTrbFinal');
			$vCosto = filter_input(INPUT_POST, 'vCosto');

			
			// get settings
			$stmt = $conn->prepare("call tarifas_cliente_insertar($vNidCliente,$vTrbInicial,$vTrbFinal,$vCosto)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;
			
		case 'actualizar':

			$vNid = filter_input(INPUT_POST, 'vNid');
			$vNidCliente = filter_input(INPUT_POST, 'vNidCliente');
			$vTrbInicial = filter_input(INPUT_POST, 'vTrbInicial');
			$vTrbFinal = filter_input(INPUT_POST, 'vTrbFinal');
			$vCosto = filter_input(INPUT_POST, 'vCosto');
			
			
			// get settings
			$stmt = $conn->prepare("call tarifas_cliente_actualizar($vNid,$vNidCliente,$vTrbInicial,$vTrbFinal,$vCosto)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;
			
		case 'eliminar':

			$vNid = filter_input(INPUT_POST, 'vNid');
			$vNidCliente = filter_input(INPUT_POST, 'vNidCliente');
			
			// get settings
			$stmt = $conn->prepare("call tarifas_cliente_borrar($vNid,$vNidCliente)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;			
		case 'consultaXestado':

			$pNidCliente = filter_input(INPUT_POST, 'pNidCliente');
			$pEstado = filter_input(INPUT_POST, 'pEstado');
		
			// get settings
			$stmt = $conn->prepare("call tarifas_cliente_consultas($pNidCliente,$pEstado)");
			$stmt->execute();

			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_tarifas();
				$respuesta->nid = $row["IdTarifa"];
				$respuesta->trbInicial = $row["TRB_Ini"];
				$respuesta->trbFinal = $row["TRB_Fin"];
				$respuesta->costo = $row["Precio"];
			
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
			
		case 'consultaXnid':

			$pNid = filter_input(INPUT_POST, 'pNid');
		
			// get settings
			$stmt = $conn->prepare("call clientes_consulta_Id($pNid)");
			$stmt->execute();	

			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_tarifas();
				$respuesta->nid = $row["IdTarifa"];
				$respuesta->trbInicial = $row["TRB_Ini"];
				$respuesta->trbFinal = $row["TRB_Fin"];
				$respuesta->trbCosto = $row["Precio"];
									
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
			
		default:
			echo json_encode(system_get_message(SISTEMA_PARAMETRO_NO_RECONOCIDO));
			break;
	}
        
?>
