<?php

/*
  Created on : Mayo 26, 2019, 01:14:34 PM
  Author     : Gabriel Hernandez Gonzalez
 */
 
	if(!isset($_SESSION)) session_start();
 
	require_once "../core/core_classes.php";
	require_once "../config.php";
	
	require_once '../assets/plugins/dompdf/autoload.inc.php';
	use Dompdf\Dompdf;

	switch (filter_input(INPUT_POST, 'tipoOperacion')) {

		case 'captura':
			
			$pServicio = filter_input(INPUT_POST, 'pServicio');
			$pImg = filter_input(INPUT_POST, 'pImg');

			$img = $pImg;
			$folderPath = "upload/".$pServicio."/";
			
			if (!file_exists($folderPath)) {
				mkdir($folderPath, 0777, true);
			}
		  
			$image_parts = explode(";base64,", $img);
			$image_type_aux = explode("image/", $image_parts[0]);
			$image_type = $image_type_aux[1];
		  
			$image_base64 = base64_decode($image_parts[1]);
			$fileName = uniqid() . '.png';
		  
			$file = $folderPath . $fileName;
			file_put_contents($file, $image_base64);
		  
			$response = new root_response;
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			$response->datos = "";
			
			echo json_encode($response);
			
			break;
		case 'consultaArchivos':
			
			$pServicio = filter_input(INPUT_POST, 'pServicio');

			$folderPath = "upload/".$pServicio."/*";
			//Get a list of file paths using the glob function.
			$fileList = glob($folderPath);
			$response = new root_response;
			//Loop through the array that glob returned.
			foreach($fileList as $filename){
			   //Simply print them out onto the screen.
				//echo $filename, '<br>'; 
				$respuesta = new core_archivo();
				$respuesta->nombre = $filename;
			
				$response->datos[] = $respuesta;
			}
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
			
		case 'consultarXestado':

			$pEstado = filter_input(INPUT_POST, 'pEstado');
			
			$user = json_decode($_SESSION['user']);			
			$vNidCliente = $user->nidCliente;

			//echo "bbb". $user->rol;
			// get settings
			if($user->rol == 3){				
				$stmt = $conn->prepare("call servicio_consultas_cliente($vNidCliente,$pEstado)");
			}else{				
				$stmt = $conn->prepare("call servicio_consultas($pEstado)");
			}
			
			$stmt->execute();			
						
			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_servicio();
				$respuesta->nid = $row["IdServicio"];
				$respuesta->servicioAmarre = $row["servicioAmarre"];
				$respuesta->fecha = $row["FechaRegistro"];    
				$respuesta->nidNaviera = $row["nidNaviera"];		
				$respuesta->naviera = $row["Naviera"];	
				$respuesta->nidBuque = $row["IdBuque"];	
				$respuesta->buque = $row["NomBuque"];
				$respuesta->imo = $row["imo"];
				$respuesta->viaje = $row["Viaje"];
				$respuesta->viajeNaviera = $row["IdViajeCliente"];;	
				$respuesta->nidTipoServicio = $row["nidTipoServicio"];	
				$respuesta->tipoServicio = $row["TipoServicio"];	
				$respuesta->nidMuelle = $row["IdMuelle"];	
				$respuesta->muelle = $row["NomMuelle"];
				$respuesta->primerCabo = $row["PrimerCabo"];	
				$respuesta->ultimoCabo = $row["UltimoCabo"];
				$respuesta->nidSupervisor = $row["Supervisor"];
				$respuesta->supervisor = $row["NomSupervisor"];	
				$respuesta->nidCliente = $row["IdCliente"];	
				$respuesta->cliente = $row["NomCliente"];	
				$respuesta->eslora = $row["Eslora"];	
				$respuesta->trb = $row["TRB"];		
				$respuesta->eta = $row["ETA"];
				$respuesta->zarpe = $row["Zarpe"];
				$respuesta->observaciones = $row["ObsGral"];
				$respuesta->costo = $row["monto"];
				$respuesta->nidProforma = $row["IdProforma"];
				$respuesta->nidFactura = $row["IdFactura"];
				$respuesta->nidFolioLocal = $row["NoFact"];
				$respuesta->uuid = $row["UUID"];
				
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
			
		case 'consultaPersonalServicio':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidPosicion = filter_input(INPUT_POST, 'pNidPosicion');
		
			// get settings
			$stmt = $conn->prepare("call servicio_personal_consultas($pNidServicio,$pNidPosicion)");
			$stmt->execute();	

			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_personal();
				$respuesta->nid = $row["IdServicioPersonal"];
				$respuesta->nombre = $row["NomPersonal"];
				$respuesta->puesto = $row["Puesto"];
				
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
			
		case 'insertaPiloto':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidPiloto = filter_input(INPUT_POST, 'pNidPiloto');
						
			// get settings
			$stmt = $conn->prepare("call servicio_pilotos_insertar($pNidServicio,$pNidPiloto)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			$response->datos = "";
			
			echo json_encode($response);
			
			break;
		case 'insertaRemolcador':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidRemolcador = filter_input(INPUT_POST, 'pNidRemolcador');
						
			// get settings
			$stmt = $conn->prepare("call servicio_remolcadores_insertar($pNidServicio,$pNidRemolcador)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			$response->datos = "";
			
			echo json_encode($response);
			
			break;
			
		case 'consultaPilotosServicio':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			
			// get settings
			$stmt = $conn->prepare("call servicio_pilotos_consultas($pNidServicio)");
			$stmt->execute();	

			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_piloto();
				$respuesta->nidServPiloto = $row["IdServicioPiloto"];
				$respuesta->nid = $row["IdPiloto"];
				$respuesta->nombre = $row["NomPiloto"];
								
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
		case 'consultaRemolcadoresServicio':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			
			// get settings
			$stmt = $conn->prepare("call servicio_remolcadores_consultas($pNidServicio)");
			$stmt->execute();	

			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_remocaldor();
				$respuesta->nidServRemolcador = $row["IdServicioRemolcadores"];
				$respuesta->nid = $row["IdRemolcador"];
				$respuesta->nombre = $row["NomRemolcador"];
								
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;
			
			
		//Inserta estados posicion, cuando servicio esta en operacion	
		case 'personalInsertar':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidPersona = filter_input(INPUT_POST, 'pNidPersona');
			$pNidPosicion = filter_input(INPUT_POST, 'pNidPosicion');

			// get settings
			$stmt = $conn->prepare("call servicio_personal_insertar($pNidServicio,$pNidPersona,$pNidPosicion)");
			$stmt->execute();	

			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;		

		case 'actualizarServicio':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pBuque = filter_input(INPUT_POST, 'pBuque');
			$pViaje = filter_input(INPUT_POST, 'pViaje');
			$pTrb = filter_input(INPUT_POST, 'pTrb');
			$pEslora = filter_input(INPUT_POST, 'pEslora');
			$pNaviera = filter_input(INPUT_POST, 'pNaviera');			
			$pEta = filter_input(INPUT_POST, 'pEta');
			$pMuelle = filter_input(INPUT_POST, 'pMuelle');
			$pTipoOperacion = filter_input(INPUT_POST, 'pTipoOperacion');
			$pCliente = filter_input(INPUT_POST, 'pCliente');
			$pSupervisor = filter_input(INPUT_POST, 'pSupervisor');
			$pComentarios = filter_input(INPUT_POST, 'pComentarios');
			$pViajeNaviera = filter_input(INPUT_POST, 'pViajeNaviera');
			
			// get settings
			$stmt = $conn->prepare("call servicio_actualizar($pNidServicio,'$pNaviera','$pBuque',$pViaje,$pTipoOperacion,$pMuelle,$pSupervisor,$pCliente,$pEslora,$pTrb,'$pEta','$pComentarios','$pViajeNaviera')");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;			
					
		case 'posicionInsertar':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pIdPosicion = filter_input(INPUT_POST, 'pIdPosicion');
			$pEstado = filter_input(INPUT_POST, 'pEstado');
			$pObservaciones = 'N/A';
		
			// get settings
			$stmt = $conn->prepare("call servicio_posicion_insertar($pNidServicio,$pIdPosicion,$pEstado,'$pObservaciones')");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;	
			
		case 'posicionConsultar':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			
			// get settings
			$stmt = $conn->prepare("call servicio_posicion_consultas($pNidServicio)");
			$stmt->execute();	

			$response = new root_response;
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
			{ 
				$respuesta = new core_posicion();
				$respuesta->nid = $row["IdPosicion"];
				$respuesta->nombre = $row["NomPosicion"];
				$respuesta->estado = $row["Estado"];
								
				$response->datos[] = $respuesta;				
			};
						
			$response->transaccion = "1";
			$response->mensaje = "Ok";
			
			echo json_encode($response);
			
			break;	
		case 'personalBorrar':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidPersonal = filter_input(INPUT_POST, 'pNidPersonal');
		
			// get settings
			$stmt = $conn->prepare("call servicio_personal_borrar($pNidServicio,$pNidPersonal)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;
		case 'pilotoBorrar':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidPilotoServicio = filter_input(INPUT_POST, 'pNidPilotoServicio');
		
			// get settings
			$stmt = $conn->prepare("call servicio_pilotos_borrar($pNidServicio,$pNidPilotoServicio)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;	
		case 'remolcadoresBorrar':

			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pNidRemolcadorServicio = filter_input(INPUT_POST, 'pNidRemolcadorServicio');
		
			// get settings
			$stmt = $conn->prepare("call servicio_remolcadores_borrar($pNidServicio,$pNidRemolcadorServicio)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;	
		case 'consultaFechaHora':
	
			// get settings
			$stmt = $conn->prepare("call servicio_ObtenerFechaCabos");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$fechaHora = $row['FechaHora'];
			
			$response = new core_fechahora;
			$response->fechaHora = $fechaHora;
			
			echo json_encode($response);
			
			break;
			
		case 'primerCaboInsertar':
			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			//$pFecha = filter_input(INPUT_POST, 'pFecha');
		
			// get settings
			$stmt = $conn->prepare("call servicio_AsignaFechaPrimerCabo($pNidServicio)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;	
			
		case 'ultimoCaboInsertar':
			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			//$pFecha = filter_input(INPUT_POST, 'pFecha');
		
			// get settings
			$stmt = $conn->prepare("call servicio_AsignaFechaUltimoCabo($pNidServicio)");
			$stmt->execute();			
						
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			$transaccion = $row['Transaccion'];
			$mensaje = $row['Mensaje'];		
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;

		case 'validaFacturacion':
				$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			
				// get settings
				$stmt = $conn->prepare("call jtmover_prodfacturacion.ValidaFacturacion(1,1,$pNidServicio)");
				$stmt->execute();			
							
				$row = $stmt->fetch(PDO::FETCH_ASSOC);
				$transaccion = $row['Transaccion'];
				$mensaje = $row['Mensaje'];
				$nidFactura = $row['NidProforma'];			
				
				$response = new root_response;
				$response->transaccion = $transaccion;
				$response->mensaje = $mensaje;
				$response->nid = $nidFactura;
								
				echo json_encode($response);
				
				break;			
		case 'prierCaboPDF':
			
			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pHtml = filter_input(INPUT_POST, 'pHtml');
						
			$content = '<html><body>';
			$content .= $pHtml;
			$content .= '</body></html>';

			$dompdf = new Dompdf();
			$dompdf->loadHtml($content);
			$dompdf->setPaper('A4', 'landscape'); // (Opcional) Configurar papel y orientaciĂ³n
			$dompdf->render(); // Generar el PDF desde contenido HTML
			$pdf = $dompdf->output(); // Obtener el PDF generado
						
			$filePath = "primerCabo/".$pNidServicio .".pdf";

			file_put_contents($filePath, $pdf);

			$transaccion = '1';
			$mensaje = 'OK';
					
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;
		case 'ultimoCaboPDF':
			
			$pNidServicio = filter_input(INPUT_POST, 'pNidServicio');
			$pHtml = filter_input(INPUT_POST, 'pHtml');
						
			$content = '<html><body>';
			$content .= $pHtml;
			$content .= '</body></html>';

			$dompdf = new Dompdf();
			$dompdf->loadHtml($content);
			$dompdf->setPaper('A4', 'landscape'); // (Opcional) Configurar papel y orientaciĂ³n
			$dompdf->render(); // Generar el PDF desde contenido HTML
			$pdf = $dompdf->output(); // Obtener el PDF generado
						
			$filePath = "ultimoCabo/".$pNidServicio .".pdf";

			file_put_contents($filePath, $pdf);

			$transaccion = '1';
			$mensaje = 'OK';
					
			
			$response = new root_response;
			$response->transaccion = $transaccion;
			$response->mensaje = $mensaje;
			
			echo json_encode($response);
			
			break;			
		default:
			echo json_encode(system_get_message(SISTEMA_PARAMETRO_NO_RECONOCIDO));
			break;
	}
        
?>
