var $table;

$("document").ready(function () {	
	$("#linkBuques").addClass("subdrop");
	inicializaValores();
    cargarDatos();
});

function cargarDatos(){	    
	$.ajax({
		type: "GET",
		url: "https://www.mediport.com.mx/mediportMovil/Buques.svc/buquesProgramados",
        contentType: "application/json",
        dataType: "json",
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			var listaBuques = resp.d.datos;
			
			    $table.dataTable().fnDestroy();
                $table.DataTable({
                    data: JSON.parse(listaBuques),
					language: JSON.parse(lenguaje),
                    autoWidth: false,
                    columns: [
						{
							
                            "data": "vid",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
								var vImo = oData.imo;
                                $(nTd).html("<span><a href='#' onclick='muestraMarineTrafic("+ vImo +")'>"+ sData +"</a></span>");
                            }
                        },
                        { "data": "buque" },
                        { "data": "eta" },
						{ "data": "naviera" },
						{ "data": "permisionaria" },
						{ "data": "descripcion_carga" }
                    ]
                });
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (e) {
			ajaxindicatorstop();
			console.log(e.message);
		}
	});
}

function muestraMarineTrafic(pImo) {
	localStorage.setItem("pImoConsultar", pImo);
	location.href = "/moversa/account.php?page=mapa";
}

function inicializaValores(){
	$table = $("#tablaBuquesProgramados");
	//$("#btnExportar").click(function(){ exportaTabla(); });
}

function exportaTabla(){
	$("#tablaBuquesProgramados").table2excel({
       filename: "buquesProgramados.xls"
    });
}