<?php
	if(!isset($_SESSION)) session_start();
	require_once "modelos/cfdi.php";
	require_once "modelos/pagos.php";
	require_once "modelos/bd.php";
	require_once "config.php";
	require_once "ws_conexion.php";
	require_once "emision.php";
	header('Content-Type: application/json');
	
	timbrado_factura_pendientes($conn);
	
	function timbrado_factura_pendientes($conexion){
		try{
			//Consulta
			$idEmpresa = $_GET['empresa'];
			$tipoSistema = $_GET['sistema'];
			
			$stmt = $conexion->prepare("call facturacion.facturas_noemitidas_consultas('$idEmpresa','$tipoSistema')");
			$stmt->execute();	
				
			$numRegistrosPendientes = $stmt->rowCount();
			$datosEncabezado = [];
			
			if($numRegistrosPendientes > 0) {
				while($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
					$respuesta = new respuesta_pendiente_timbrar_factura();
					$respuesta->IdFactura = $row["IdFactura"];
					$respuesta->TipoSistema = $row["TipoSistema"];
					$respuesta->IdCliente = $row["IdCliente"];
					$respuesta->NomCliente = $row["NomCliente"];
					$respuesta->folioCFDI = $row["folioCFDI"];
					$respuesta->Subtotal = $row["Subtotal"];
					$respuesta->IVA = $row["IVA"];
					$respuesta->Total = $row["Total"];
					
					$datosPendientes[] = $respuesta;
					//return json_encode($datosEncabezado);			
				};
				$stmt->closeCursor();
			} else {
				return "No se pudieron obtener los comprobantes pendientes de timbrado";
			}
			
			//Por cada elemento en datosPendientes enviamos una peticion de timbrado
			for ($x = 0; $x < count($datosPendientes); $x++){
				timbrado_factura($idEmpresa, $tipoSistema, $datosPendientes[x]->IdFactura, $conexion);
			}
		} catch (Exception $e){
			return "Error al consultar los pendientes de timbrado: " . $e;
		}
	}
	
	class respuesta_pendiente_timbrar_factura{
		public $IdFactura;
		public $TipoSistema;
		public $IdCliente;
		public $NomCliente;
		public $folioCFDI;
		public $Subtotal;
		public $IVA;
		public $Total;
	}
	
?>